% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure_split.R
\name{figure_splitPlot}
\alias{figure_splitPlot}
\title{Splits a composite figure that contains multiple plots.}
\usage{
figure_splitPlot(file = file.choose(), binary_threshold = 0.6,
  space_sensitivity_X = 0.4, space_sensitivity_Y = 0.6, border_buffer = 5,
  guess_limit = 10, ignoreX = FALSE, ignoreY = FALSE, quiet = FALSE)
}
\arguments{
\item{file}{The file name and location of a composite figure.  Prompts
for file name if none is explicitly called.}

\item{binary_threshold}{A proportion from zero to one designating the 
gray-scale threshold to convert pixels into black or white.  Pixel
intensities below the proportion will be converted to black, and those 
above white.}

\item{space_sensitivity_X}{A proportion ranging from zero to one that 
designates the size of the separation among sub-plots along the X-axis 
relative to the largest empty space detected in the figure image.  As
space_sensitivity_X approaches 1, finer empty spaces (e.g., empty spaces
found in between plot captions and the axis line) will be treated as plot
divisions.}

\item{space_sensitivity_Y}{A proportion ranging from zero to one that 
designates the size of the seperation among sub-plots along the Y-axis 
relative to the largest empty space detected in the figure image.  As
space_sensitivity_Y approaches 1, finer empty spaces (e.g., empty spaces
found in between plot captions and the axis line) will be treated as plot
divisions.}

\item{border_buffer}{An integer value designating the amount of empty space
around the figure image that should be ignored.  As the number increases,
more blank space near the image's edge will be ignored.}

\item{guess_limit}{An integer value designating the number of guesses for 
within a figure image.  The default value designates the top 10 guesses of 
divisions.  Increase this number if there are more than 6 subplots per axis.}

\item{ignoreX}{When \code{TRUE}, ignores detection of sub-plots along the 
X-axis.}

\item{ignoreY}{When \code{TRUE}, ignores detection of sub-plots along the 
Y-axis.}

\item{quiet}{When \code{TRUE}, does not print to console the saved file names.}
}
\value{
The number of sub-plots saved to file.
}
\description{
Automatically detects divisions among multiple plots found within a single
figure image file.  It then uses these divisions to split the image into 
multiple image files; each containing only a single X-Y plot.  Currently only
works on composite figures that have a matrix-style presentation where each 
sub-plot has the same size.
}
