### library(metafor); library(testthat); Sys.setenv(NOT_CRAN="true")

### see also: https://www.metafor-project.org/doku.php/plots:normal_qq_plots

source("settings.r")

context("Checking plots example: normal QQ plots")

test_that("plot can be drawn for 'rma.uni' object.", {

   expect_equivalent(TRUE, TRUE) # avoid 'Empty test' message

   skip_on_cran()

   opar <- par(no.readonly=TRUE)

   ### set up 2x2 array for plotting
   par(mfrow=c(2,2))

   ### calculate log risk ratios and corresponding sampling variances
   dat <- escalc(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)

   ### fit equal- and random-effects models
   res1 <- rma(yi, vi, data=dat, method="EE")
   res2 <- rma(yi, vi, data=dat)

   ### fit fixed- and random-effects models with absolute latitude moderator
   res3 <- rma(yi, vi, mods=~ablat, data=dat, method="FE")
   res4 <- rma(yi, vi, mods=~ablat, data=dat)

   ### normal QQ plots for the various models
   qqnorm(res1, main="Equal-Effects Model")
   qqnorm(res2, main="Random-Effects Model")
   qqnorm(res3, main="Fixed-Effects with Moderators Model")
   qqnorm(res4, main="Mixed-Effects Model")

   par(opar)

   ### draw plot with studentized residuals and labels
   qqnorm(res2, type="rstudent", label=TRUE)

})

test_that("plot can be drawn for 'rma.mh' object.", {

   expect_equivalent(TRUE, TRUE) # avoid 'Empty test' message

   skip_on_cran()

   opar <- par(no.readonly=TRUE)
   res <- rma.mh(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)
   qqnorm(res)
   qqnorm(res, type="rstudent", label=TRUE)
   par(opar)

})

test_that("plot can be drawn for 'rma.peto' object.", {

   expect_equivalent(TRUE, TRUE) # avoid 'Empty test' message

   skip_on_cran()

   opar <- par(no.readonly=TRUE)
   res <- rma.peto(ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)
   qqnorm(res)
   qqnorm(res, type="rstudent", label=TRUE)
   par(opar)

})

test_that("plot cannot be drawn for 'rma.mv' object.", {

   dat <- escalc(measure="RR", ai=tpos, bi=tneg, ci=cpos, di=cneg, data=dat.bcg)
   res <- rma.mv(yi, vi, random = ~ 1 | trial, data=dat, sparse=sparse)
   expect_error(qqnorm(res))

})

rm(list=ls())
