% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{is_branch}
\alias{is_branch}
\title{Test if taxa are branches}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object.}
}
\value{
A `logical` of length equal to the number of taxa.
}
\description{
Test if taxa are branches in a [taxonomy()] or [taxmap()] object. Branches
are taxa in the interior of the tree that are not [roots()], [stems()], or
[leaves()].
\preformatted{
obj$is_branch()
is_branch(obj)}
}
\examples{
# Test which taxon IDs correspond to branches
is_branch(ex_taxmap)

# Filter out branches
filter_taxa(ex_taxmap, ! is_branch)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data}()},
\code{\link{map_data_}()},
\code{\link{n_leaves}()},
\code{\link{n_leaves_1}()},
\code{\link{n_subtaxa}()},
\code{\link{n_subtaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
