% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxon_name.R
\name{taxon_name}
\alias{taxon_name}
\title{Taxon name class}
\usage{
taxon_name(name, database = NULL)
}
\arguments{
\item{name}{(character) a taxonomic name. required}

\item{database}{(character) database class object, optional}
}
\value{
An `R6Class` object of class `TaxonName`
}
\description{
Used to store the name of taxa. This is typically used to
store where taxon names in [taxon()] objects.
}
\examples{
(poa <- taxon_name("Poa"))
(undef <- taxon_name("undefined"))
(sp1 <- taxon_name("species 1"))
(poa_annua <- taxon_name("Poa annua"))
(x <- taxon_name("Poa annua L."))

x$name
x$database

(x <- taxon_name(
  "Poa annua",
  database_list$ncbi
))
x$rank
x$database

# a null taxon_name object
taxon_name(NULL)
}
\seealso{
Other classes: 
\code{\link{hierarchies}()},
\code{\link{hierarchy}()},
\code{\link{taxa}()},
\code{\link{taxmap}()},
\code{\link{taxon_database}()},
\code{\link{taxon_id}()},
\code{\link{taxon_rank}()},
\code{\link{taxonomy}()},
\code{\link{taxon}()}
}
\concept{classes}
