% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--filter.R
\name{filter_taxa}
\alias{filter_taxa}
\title{Filter taxa with a list of conditions}
\usage{
filter_taxa(.data, ..., subtaxa = FALSE, supertaxa = FALSE,
  taxonless = FALSE, reassign_obs = TRUE, reassign_taxa = TRUE,
  invert = FALSE)
}
\arguments{
\item{.data}{\code{\link{taxmap}}}

\item{...}{One or more filtering conditions. This can be one of three things: \describe{ 
\item{\code{character}}{One or more \code{taxon_id}s} \item{\code{integer}}{One or more indexes
of \code{taxon_data}} \item{\code{logical}}{A \code{TRUE}/\code{FALSE} vector of length equal 
to the number of rows in \code{taxon_data}} } Any column name that appears in 
\code{taxon_data(.data)} can be used as if it was a vector on its own.}

\item{subtaxa}{(\code{logical} of length 1) If \code{TRUE}, include subtaxa of taxa passing the 
filter.}

\item{supertaxa}{(\code{logical} of length 1) If \code{TRUE}, include supertaxa of taxa passing 
the filter.}

\item{taxonless}{(\code{logical} of length 1) If \code{TRUE}, include observations even if the
taxon they are assigned to is filtered out. observation assigned to removed taxa will be
assigned to \code{NA}. See the \code{reassign} option below for further complications.}

\item{reassign_obs}{(\code{logical} of length 1) If \code{TRUE}, observations assigned to removed
taxa will be reassigned to the closest supertaxon that passed the filter. If there are no
supertaxa of such an observation that passed the filter, they will be filtered out if
\code{taxonless} is \code{TRUE}.}

\item{reassign_taxa}{(\code{logical} of length 1) If \code{TRUE}, subtaxa of removed taxa will be
reassigned to the closest supertaxon that passed the filter.}

\item{invert}{(\code{logical} of length 1) If \code{TRUE}, do NOT include the selection.
This is different than just replacing a \code{==} with a \code{!=} because this option negates
the selection after taking into account the \code{subtaxa} and \code{supertaxa} options.
This is useful for removing a taxon and all its subtaxa for example.}
}
\value{
An object of type \code{\link{taxmap}}
}
\description{
Filter taxa in a \code{\link{taxmap}} object with a list of conditions. Any column name that 
appears in \code{taxon_data(.data)} can be used as if it was a vector on its own. See 
\code{\link[dplyr]{filter}} for inspiration and more information.
}
\examples{
# Remove singleton taxa, but reassign singletons to supertaxa that pass filter
filter_taxa(unite_ex_data_3, n_obs > 1)
# Remove singleton taxa and associated seqeuence data
filter_taxa(unite_ex_data_3, n_obs > 1, taxonless = FALSE, reassign_obs = FALSE)
# Subset to a single taxon and its subtaxa
filter_taxa(unite_ex_data_3, name == "Basidiomycota", subtaxa = TRUE)
# Remove a taxon and its subtaxa
filter_taxa(unite_ex_data_3, name == "Basidiomycota", subtaxa = TRUE, invert = TRUE)
# Remove taxa, reassigning supertaxa and subtaxa 
filter_taxa(unite_ex_data_3, unite_rank != "p")

}
\seealso{
Other dplyr-like functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_obs}},
  \code{\link{mutate_obs}}, \code{\link{mutate_taxa}},
  \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{select_taxa}},
  \code{\link{transmute_obs}}, \code{\link{transmute_taxa}}
}
