% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANOVA_med_range_quart.R
\name{es_from_med_min_max_quarts}
\alias{es_from_med_min_max_quarts}
\title{Convert median, range and interquartile range of two independent groups into several effect size measures}
\usage{
es_from_med_min_max_quarts(
  q1_exp,
  med_exp,
  q3_exp,
  min_exp,
  max_exp,
  n_exp,
  q1_nexp,
  med_nexp,
  q3_nexp,
  min_nexp,
  max_nexp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_med
)
}
\arguments{
\item{q1_exp}{first quartile of the experimental/exposed group.}

\item{med_exp}{median value of the experimental/exposed group.}

\item{q3_exp}{third quartile of the experimental/exposed group.}

\item{min_exp}{minimum value of the experimental/exposed group.}

\item{max_exp}{maximum value of the experimental/exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{q1_nexp}{first quartile of the non-experimental/non-exposed group.}

\item{med_nexp}{median value of the non-experimental/non-exposed group.}

\item{q3_nexp}{third quartile of the non-experimental/non-exposed group.}

\item{min_nexp}{minimum value of the non-experimental/non-exposed group.}

\item{max_nexp}{maximum value of the non-experimental/non-exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the generated \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_med}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab \cr
\tab \cr
\code{converted effect size measure} \tab MD + D + G\cr
\tab OR + R + Z \cr
\code{required input data} \tab See 'Section 12. Median, range and/or interquartile range'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert median, range and interquartile range of two independent groups into several effect size measures
}
\details{
This function first converts a Cohen's d (D), Hedges' g (G) and mean difference (MD)
from the medians, ranges, and interquartile ranges of two independent groups.
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{This function recreates means+SD of the two groups}  (Wan et al., 2014):
\deqn{mean\_exp = \frac{min\_exp + 2*q1\_exp + 2*med\_exp + 2*q3\_exp + max\_exp}{8}}
\deqn{mean\_nexp = \frac{min\_nexp + 2*q1\_nexp + 2*med\_nexp + 2*q3\_nexp + max\_nexp}{8}}
\deqn{mean\_sd\_exp = \frac{max\_exp - min\_exp}{4*qnorm(\frac{n\_exp-0.375}{n\_exp+0.25})} + \frac{q3\_exp-q1\_exp}{4*qnorm(\frac{0.75*n\_exp-0.125}{n\_exp+0.25})}}
\deqn{mean\_sd\_nexp = \frac{max\_nexp - min\_nexp}{4*qnorm(\frac{n\_nexp-0.375}{n\_nexp+0.25})} + \frac{q3\_nexp-q1\_nexp}{4*qnorm(\frac{0.75*n\_nexp-0.125}{n\_nexp+0.25})}}

Note that if the group sample size is inferior to 50, a correction is applied to estimate the standard deviation.

\strong{From these means+SD, the function computes MD, D and G} using formulas
described in \code{\link{es_from_means_sd}()}.

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_med_min_max_quarts(
  min_exp = 1102, q1_exp = 1335,
  med_exp = 1400, q3_exp = 1765,
  max_exp = 1899, n_exp = 40,
  min_nexp = 1181, q1_nexp = 1481,
  med_nexp = 1625, q3_nexp = 1800,
  max_nexp = 1910, n_nexp = 40
)
}
\references{
Wan, X., Wang, W., Liu, J. et al. Estimating the sample mean and standard deviation from the sample size, median, range and/or interquartile range. BMC Med Res Methodol 14, 135 (2014). https://doi.org/10.1186/1471-2288-14-135
}
