% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_SMD.R
\name{es_from_cohen_d_adj}
\alias{es_from_cohen_d_adj}
\title{Convert an adjusted Cohen's d value to several effect size measures}
\usage{
es_from_cohen_d_adj(
  cohen_d_adj,
  n_cov_ancova,
  cov_outcome_r,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_d
)
}
\arguments{
\item{cohen_d_adj}{Adjusted Cohen's d (i.e., standardized mean difference) value.}

\item{n_cov_ancova}{number of covariates}

\item{cov_outcome_r}{covariate-outcome correlation (in case of multiple covariates, the multiple correlation)}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_d}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z\cr
\tab \cr
\code{required input data} \tab See 'Section 1. Cohen's d or Hedges' g'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert an adjusted Cohen's d value to several effect size measures
}
\details{
This function estimates the standard error of an adjusted Cohen's d value and Hedges' g (G), and
converts an odds ratio (OR) and correlation coefficients (R/Z).

\strong{To estimate the standard error of Cohen's d}, the following formula is used (table 12.3 in Cooper):
\deqn{d\_se = \sqrt{\frac{n\_exp+n\_nexp}{n\_exp*n\_nexp} * (1 - cov\_outcome\_r^2) + \frac{cohen\_d\_adj^2}{2*(n\_exp+n\_nexp)}}}

\strong{To estimate other effect size measures}, calculations of the
\code{\link{es_from_cohen_d}()} function are used (with the exception of the degree of freedom
that is estimated as \code{df = n_exp + n_nexp - 2 - n_cov_ancova}).
}
\examples{
es_from_cohen_d_adj(cohen_d_adj = 1, n_cov_ancova = 4, cov_outcome_r = .30, n_exp = 20, n_nexp = 20)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
