% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getElevation.R
\name{getElevation}
\alias{getElevation}
\title{Filter environmental monitoring stations by elevation}
\usage{
getElevation(elevMin, elevMax, ...)
}
\arguments{
\item{elevMin}{(numeric) defines the minimum elevation to filter metadata.  Units are in meters (m) Above Sea Level.}

\item{elevMax}{(numeric) defines the maximum elevation to filter metadata.  Units are in meters (m) Above Sea Level.}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata of environmental monitoring stations that have elevations conforming to the criteria specified in \code{elevThresh}\cr
}
\description{
Return metadata of environmental monitoring stations that have a specific elevation.
}
\examples{
\dontrun{
#return metadata of sites that have elevations above 1500 (m) Above Sea Level
  getElevation(elevMin=1500)
#return metadata of sites that have elevations less than 35 (m) Above Sea Level
  getElevation(elevMax=35)}
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapResults}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
}
