% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitLm.R
\name{FitLm}
\alias{FitLm}
\title{Fast estimates of linear regression}
\usage{
FitLm(y, ..., se = FALSE)
}
\arguments{
\item{y}{numeric vector of observations to model}

\item{...}{numeric vectors of variables used in the modeling}

\item{se}{logical indicating whether to compute the standard error}
}
\value{
a list with elements
\describe{
\item{term}{the name of the regressor}
\item{estimate}{estimate of the regression}
\item{std.error}{standard error}
\item{df}{degrees of freedom}
}

If there's no complete cases in the regression, \code{NA}s are returned with no
warning.
}
\description{
Computes a linear regression with \link[stats:.lm.fit]{stats::.lm.fit} and returns the estimate
and, optionally, standard error for each regressor.
}
\examples{
# Linear trend with "signficant" areas shaded with points
library(data.table)
library(ggplot2)
system.time({
  regr <- geopotential[, FitLm(gh, date, se = TRUE), by = .(lon, lat)]
})

ggplot(regr[term != "(intercept)"], aes(lon, lat)) +
    geom_contour(aes(z = estimate, color = ..level..)) +
    stat_subset(aes(subset = abs(estimate) > 2*std.error), size = 0.05)

# Using stats::lm() is much slower and with no names.
\dontrun{
system.time({
  regr <- geopotential[, coef(lm(gh ~ date)), by = .(lon, lat)]
})
}

}
