% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-unbinned.R
\docType{data}
\name{scale_fill_discretised}
\alias{scale_fill_discretised}
\alias{scale_fill_divergent_discretised}
\alias{discretised_scale}
\alias{ScaleDiscretised}
\title{Discretised scale}
\usage{
scale_fill_discretised(
  ...,
  low = "#132B43",
  high = "#56B1F7",
  space = "Lab",
  na.value = "grey50",
  guide = ggplot2::guide_colorsteps(even.steps = FALSE, show.limits = TRUE),
  aesthetics = "fill"
)

scale_fill_divergent_discretised(
  ...,
  low = scales::muted("blue"),
  mid = "white",
  high = scales::muted("red"),
  midpoint = 0,
  space = "Lab",
  na.value = "grey50",
  guide = ggplot2::guide_colorsteps(even.steps = FALSE, show.limits = TRUE)
)

discretised_scale(
  aesthetics,
  scale_name,
  palette,
  name = ggplot2::waiver(),
  breaks = ggplot2::waiver(),
  labels = ggplot2::waiver(),
  limits = NULL,
  trans = scales::identity_trans(),
  na.value = NA,
  drop = FALSE,
  guide = ggplot2::guide_colorsteps(even.steps = FALSE),
  position = "left",
  rescaler = scales::rescale,
  oob = scales::censor,
  super = ScaleDiscretised
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:continuous_scale]{continuous_scale}}
  \describe{
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{palette}}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding output values
(e.g., \code{\link[scales:area_pal]{scales::area_pal()}}).}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}})
}}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}
    \item{\code{n.breaks}}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}
    \item{\code{rescaler}}{A function used to scale the input values to the
range [0, 1]. This is always \code{\link[scales:rescale]{scales::rescale()}}, except for
diverging and n colour gradients (i.e., \code{\link[ggplot2:scale_gradient]{scale_colour_gradient2()}},
\code{\link[ggplot2:scale_gradient]{scale_colour_gradientn()}}). The \code{rescaler} is ignored by position
scales, which always use \code{\link[scales:rescale]{scales::rescale()}}.}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds).
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}
    \item{\code{trans}}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{<name>_trans} (e.g.,
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}). You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{low}{Colours for low and high ends of the gradient.}

\item{high}{Colours for low and high ends of the gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{mid}{colour for mid point}

\item{midpoint}{The midpoint (in data value) of the diverging scale.
Defaults to 0.}

\item{scale_name}{The name of the scale that should be used for error messages
associated with this scale.}

\item{palette}{A palette function that when called with a numeric vector with
values between 0 and 1 returns the corresponding output values
(e.g., \code{\link[scales:area_pal]{scales::area_pal()}}).}

\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}})
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{trans}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{<name>_trans} (e.g.,
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}). You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}

\item{drop}{Should unused factor levels be omitted from the scale? The default, TRUE, uses the
levels that appear in the data; FALSE uses all the levels in the factor.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{rescaler}{A function used to scale the input values to the
range [0, 1]. This is always \code{\link[scales:rescale]{scales::rescale()}}, except for
diverging and n colour gradients (i.e., \code{\link[ggplot2:scale_gradient]{scale_colour_gradient2()}},
\code{\link[ggplot2:scale_gradient]{scale_colour_gradientn()}}). The \code{rescaler} is ignored by position
scales, which always use \code{\link[scales:rescale]{scales::rescale()}}.}

\item{oob}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds).
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}

\item{super}{The super class to use for the constructed scale}
}
\description{
This scale allows ggplot to understand data that has been discretised with
some procedure akin to \code{cut} and access the underlying continuous values.
For a scale that does the opposite (take continuous data and treat them as
discrete) see \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}}.
}
\details{
This scale makes it very easy to synchronise the breaks of filled contours
and the breaks shown no the colour guide. Bear in mind that when using
\code{\link[=geom_contour_fill]{geom_contour_fill()}}, the default fill aesthetic (\code{level_mid}) is \strong{not}
discretised. To use this scale with that geom, you need to set
\code{aes(fill = stat(level))}.
}
\examples{
library(ggplot2)

# Using the `level` compute aesthetic from `geom_contour_fill()`
# (or ggplot2::geom_contour_filled()), the default scale is discrete.
# This means that you cannot map colours to the underying numbers.
v <- ggplot(faithfuld, aes(waiting, eruptions, z = density))
v + geom_contour_fill(aes(fill = stat(level)))

v + geom_contour_fill(aes(fill = stat(level))) +
  scale_fill_discretised()

# The scale can be customised the same as any continuous colour scale
v + geom_contour_fill(aes(fill = stat(level))) +
  scale_fill_discretised(low = "#a62100", high = "#fff394")

# Setting limits explicitly will truncate the scale
# (if any limit is inside the range of the breaks but doesn't
# coincide with any range, it will be rounded with a warning)
v + geom_contour_fill(aes(fill = stat(level))) +
  scale_fill_discretised(low = "#a62100", high = "#fff394",
                         limits = c(0.01, 0.028))

# Or extend it.
v + geom_contour_fill(aes(fill = stat(level))) +
  scale_fill_discretised(low = "#a62100", high = "#fff394",
                         limits = c(0, 0.07))

v + geom_contour_fill(aes(fill = stat(level))) +
  scale_fill_divergent_discretised(midpoint = 0.02)

# Existing continous scales can be "retrofitted" by changing the `super`
# and `guide` arguments.
v + geom_contour_fill(aes(fill = stat(level))) +
    scale_fill_distiller(super = ScaleDiscretised)

# Unequal breaks will, by default, map to unequal spacing in the guide
v + geom_contour_fill(aes(fill = stat(level)), breaks = c(0, 0.005, 0.01, 0.02, 0.04)) +
  scale_fill_discretised()

# You can change that by the `even.steps` argument on ggplot2::guide_colorsteps()
v + geom_contour_fill(aes(fill = stat(level)), breaks = c(0, 0.005, 0.01, 0.02, 0.04)) +
  scale_fill_discretised(guide = guide_colorsteps(even.steps = TRUE, show.limits = TRUE))


}
\keyword{datasets}
