% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce_from_messydate.R
\name{coerce_from}
\alias{coerce_from}
\alias{as.Date.mdate}
\alias{as.POSIXct.mdate}
\alias{as.POSIXlt.mdate}
\title{Coercion from messy dates}
\usage{
\method{as.Date}{mdate}(x, FUN = vmin, ...)

\method{as.POSIXct}{mdate}(x, tz = "UTC", FUN = vmin, ...)

\method{as.POSIXlt}{mdate}(x, tz = "UTC", FUN = vmin, ...)
}
\arguments{
\item{x}{A \code{mdate} object}

\item{FUN}{A function that can be used to resolve expanded messy dates
into a single date.
For example, \code{min()}, \code{max()}, \code{mean()}, \code{median()},
\code{modal()}, and \code{random()}.}

\item{...}{Arguments passed on to the S3 generics.}

\item{tz}{Character string specifying the time zone for the conversion,
if required.
By default "UTC" (Universal Time Coordinated), equivalent to GMT.
If "" then the current time zone is used.}
}
\value{
A date object of \code{Date}, \code{POSIXct}, or \code{POSIXlt} class
}
\description{
These functions coerce objects of \code{mdate} class to
common date classes such as \code{Date}, \code{POSIXct}, and \code{POSIXlt}.
Since \code{mdate} objects can hold multiple individual dates,
however, an additional function must be passed as an argument
so that these functions know how to coerce resolve multiple dates
into a single date.

For example, one might wish to use the earliest possible date
in any ranges of dates (\code{min}), the latest possible date (\code{max}),
some notion of a central tendency (\code{mean}, \code{median}, or \code{modal}),
or even a \code{random} selection from among the candidate dates.

These functions then, building on \code{expand()} and the resolve functions,
are particularly useful in converting back out of the \code{mdate} class
for use with existing methods and models,
especially for checking the robustness of results.
}
\examples{
as.Date(as_messydate("2012-01"), FUN = vmin)
as.Date(as_messydate("2012-01-01"), FUN = vmean)
as.Date(as_messydate("2012-01"), FUN = vmax)
as.Date(as_messydate("2012-01"), FUN = vmedian)
as.Date(as_messydate("2012-01"), FUN = vmodal)
as.Date(as_messydate("2012-01"), FUN = vrandom)
as.Date(as_messydate("1000 BC"), FUN = vmax)
as.Date(as_messydate("1000 BC"), FUN = vmedian)
as.Date(as_messydate(c("-1000", "2020")), FUN = vmin)
}
