% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grplot.R
\name{cmix}
\alias{cmix}
\title{Fast general purpose color mixer}
\usage{
cmix(col_1, col_2, weight, format = "hex")
}
\arguments{
\item{col_1, col_2}{character vector of length one or of matching length containing
colors either as a color name (see \link{colors}), rgb format (see \link{rgb}), or
hex format.}

\item{weight}{numeric between 0 and 1 specifying the relative mixing weight for color
one. E.g., \code{weight = .8} means that final color is composed of 80 percent
\code{col_2} and 20 percent \code{col_1}.}

\item{format}{character string specifying the output format. Either \code{"hex"} or
\code{"rgb"}.}
}
\value{
A vector of length \code{max(length(col_1), length(col_2))} containing the
mixed colors in the specified format.
}
\description{
Mixes two colors or matching vectors of colors according to some relative weight
and exports the result either in rgb or hex format.
}
\examples{

# mix blue and red with more weight on blue
cmix('blue', 'red', .2)

# mix blue and red with more weight on red
cmix('blue', 'red', .8)

# mix blue and red and return as rgb
cmix('blue', 'red', .8, format = 'rgb')

}
