% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.analysis.R
\name{roc.analysis}
\alias{roc.analysis}
\title{Analysis of different indicators to find the optimum value of the window parameter}
\usage{
roc.analysis(i.data, i.param.values = seq(1.5, 4.5, 0.1), i.graph = F,
  i.graph.file = F, i.graph.file.name = "", i.graph.title = "",
  i.graph.subtitle = "", i.output = ".", ...)
}
\arguments{
\item{i.data}{Data frame of input data.}

\item{i.param.values}{range of i.param values to test.}

\item{i.graph}{create a graph with the outputs (T/F).}

\item{i.graph.file}{write the graph to a file.}

\item{i.graph.file.name}{name of the output file.}

\item{i.graph.title}{title of the graph.}

\item{i.graph.subtitle}{subtitle of the graph.}

\item{i.output}{output directory.}

\item{...}{other paramaters to be used by memgoodness function.}
}
\value{
\code{roc.analysis} returns a list.
An object of class \code{mem} is a list containing at least the following components:
\itemize{
  \item{optimum} {optimum value.}
  \item{results} {Detailed results of each iteration.}
}
}
\description{
Function \code{roc.analysis} perform a ROC analysis
}
\details{
Optimize is an iterative process that calculates goodness indicators using different window
parameters for the fixed criterium and compares all estimators in order to find the optimum
window parameter.

The output shows the different window parameters and their respective indicators to decide
which one is better for your data.
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# ROC analysis
epi.roc<-roc.analysis(flucyl,i.param.values=seq(2.6,2.8,0.1),i.detection.values=seq(2.6,2.8,0.1))
epi.roc$results

}
\references{
Vega T, Lozano JE, Ortiz de Lejarazu R, Gutierrez Perez M. Modelling influenza epidemic - can we
detect the beginning and predict the intensity and duration? Int Congr Ser. 2004 Jun;1263:281-3.

Vega T, Lozano JE, Meerhoff T, Snacken R, Mott J, Ortiz de Lejarazu R, et al. Influenza surveillance
in Europe: establishing epidemic thresholds by the moving epidemic method. Influenza Other Respir
Viruses. 2013 Jul;7(4):546-58. DOI:10.1111/j.1750-2659.2012.00422.x.

Vega T, Lozano JE, Meerhoff T, Snacken R, Beaute J, Jorgensen P, et al. Influenza surveillance in
Europe: comparing intensity levels calculated using the moving epidemic method. Influenza Other
Respir Viruses. 2015 Sep;9(5):234-46. DOI:10.1111/irv.12330.

Lozano JE. lozalojo/mem: Second release of the MEM R library. Zenodo [Internet]. [cited 2017 Feb 1];
Available from: \url{https://zenodo.org/record/165983}. DOI:10.5281/zenodo.165983
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
