% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd9cm.R
\name{merge_icd9_dx_and_procs}
\alias{merge_icd9_dx_and_procs}
\title{Merge ICD-9-CM diagnostic and procedure codes}
\usage{
merge_icd9_dx_and_procs(dx_df, proc_df, icd9dxvar = "icd9cm",
  icd9pvar = "icd9cm")
}
\arguments{
\item{dx_df}{a data frame with at least two columns, specified as \code{idvar}
and \code{icd9dxvar}, where the values are ICD-9 diagnostic codes}

\item{proc_df}{a data frame with at least two columns, specified as \code{idvar}
and \code{icd9pvar}, where the values are ICD-9 procedure codes}

\item{icd9dxvar}{name of icd9 diagnostic code column, default "icd9cm"}

\item{icd9pvar}{name of icd9 procedure code column, default "icd9cm"}
}
\value{
a merged dataframe with common columns and \code{"icd9cm"}
}
\description{
Merges a dataframe containing ICD-9-CM diagostic codes with a dataframe containing ICD-9 procedure codes
Diagnostic codes are prefixed with 'D', while procedure codes are prefixed with 'P'
}
\examples{
cases <- data.frame(id=c(1,2),
                    icd9dxlist=c('162.4,070.30,155.0,401.9','996.52,E878.8,V45.86'), 
                    icd9plist=c('38.16','38.42'))
dx_df <- melt_icd9list(cases, "id", "icd9dxlist")
proc_df <- melt_icd9list(cases, "id", "icd9plist")
merge_icd9_dx_and_procs(dx_df, proc_df)
}

