% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R
\name{tiling_correlogramcpp}
\alias{tiling_correlogramcpp}
\title{Compute all STTPs for a set of spike trains}
\usage{
tiling_correlogramcpp(spikes, n, nspikes, first_spike, start, end, dt, tau_sep,
  tau_max)
}
\arguments{
\item{spikes}{Concatenated list of spike trains}

\item{n}{number of spike trains}

\item{nspikes}{Vector containing the number of spikes in each train}

\item{first_spike}{Index to the first spike in each train.}

\item{start}{Start time of recording in seconds}

\item{end}{End time of recording in seconds}

\item{dt}{Coincidence window for STTC}

\item{tau_sep}{Step size for taus.}

\item{tau_max}{Maximum absolute tau value.}
}
\value{
Pairwise STTPs for all spike trains
}
\description{
Compute all STTPs for a set of spike trains
}
\details{
This computes all pairwise STTPs for spike trains.  (This may be of use
for Tom's internal code, rather than for production use.)
}
\author{
Tom Edinburgh
}
