/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.core.clusterings;

import multidendrograms.core.clusterings.LanceWilliams;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;

public class BetaFlexible
extends LanceWilliams {
    private boolean isWeighted;
    private double beta;

    public BetaFlexible(SymmetricMatrix symmetricMatrix, String[] stringArray, boolean bl, int n, boolean bl2, double d) {
        super(symmetricMatrix, stringArray, bl, n);
        this.isWeighted = bl2;
        this.beta = this.isDistanceBased ? d : -d;
    }

    @Override
    protected double getAlpha(Dendrogram dendrogram, Dendrogram dendrogram2, Dendrogram dendrogram3, Dendrogram dendrogram4) {
        double d = this.isWeighted ? 1.0 / (double)dendrogram.numberOfSubroots() : (double)dendrogram2.numberOfLeaves() / (double)dendrogram.numberOfLeaves();
        double d2 = this.isWeighted ? 1.0 / (double)dendrogram3.numberOfSubroots() : (double)dendrogram4.numberOfLeaves() / (double)dendrogram3.numberOfLeaves();
        return d * d2 * (1.0 - this.beta);
    }

    @Override
    protected double getBeta(Dendrogram dendrogram, Dendrogram dendrogram2, Dendrogram dendrogram3, Dendrogram dendrogram4) {
        double d;
        if (this.isWeighted) {
            int n = dendrogram.numberOfSubroots();
            int n2 = dendrogram4.numberOfSubroots();
            d = 1.0 / (double)((n - 1) * n / 2 + (n2 - 1) * n2 / 2);
        } else {
            d = (double)(dendrogram2.numberOfLeaves() * dendrogram3.numberOfLeaves()) / (this.sigma(dendrogram) + this.sigma(dendrogram4));
        }
        return d * this.beta;
    }

    private double sigma(Dendrogram dendrogram) {
        int n = dendrogram.numberOfLeaves() * dendrogram.numberOfLeaves();
        for (int i = 0; i < dendrogram.numberOfSubroots(); ++i) {
            Dendrogram dendrogram2 = dendrogram.getSubroot(i);
            n -= dendrogram2.numberOfLeaves() * dendrogram2.numberOfLeaves();
        }
        return 0.5 * (double)n;
    }
}

