% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regcoeffs.R
\name{regcoeffs.getStats}
\alias{regcoeffs.getStats}
\title{Distribution statistics for regression coeffificents}
\usage{
regcoeffs.getStats(coeffs, ci.coeffs = NULL, use.mean = TRUE)
}
\arguments{
\item{coeffs}{array (npred x ncomp x nresp) with regression coefficients}

\item{ci.coeffs}{array (npred x ncomp x nresp x cv) with regression coefficients for
computing confidence intervals (e.g. from cross-validation) using Jack-Knifing method}

\item{use.mean}{logical, tells how to compute standard error for regression coefficients. If \code{TRUE}
mean values for ci.coeffs is computed first. If \code{FALSE}, \code{values} (coefficients
computed for global model) are used as mean.}
}
\value{
a list with statistics three arrays: srandard error, t-values and p-values computed for
each regression coefficient.
}
\description{
calculates standard error, t-values and p-values for
regression coefficients based on Jack-Knifing method.
}
