% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_mse}
\alias{calc_mse}
\title{Calculate Mean Squared Error and its Monte Carlo Standard Error}
\usage{
calc_mse(estimates, true_param)
}
\arguments{
\item{estimates}{A numeric vector of estimates from a simulation or sampling process.}

\item{true_param}{The true parameter value that the estimates are intended to approximate.}
}
\value{
A list with two components: `mse`, the calculated Mean Squared Error of the estimates,
and `mse_mcse`, the Monte Carlo Standard Error of the MSE, offering insight into the reliability
of the MSE calculation.
}
\description{
Computes the Mean Squared Error (MSE) of a set of estimates relative to a true parameter value,
along with the Monte Carlo Standard Error (MCSE) for the MSE. The MCSE takes into account the
variance, skewness, and kurtosis of the estimates to provide a more accurate measure of uncertainty.
This function is useful for assessing the accuracy of simulation or estimation methods by comparing
the squared deviations of estimated values from a known parameter.
}
\examples{
estimates <- rnorm(100, mean = 50, sd = 10)
true_param <- 50
mse_info <- calc_mse(estimates, true_param)
print(mse_info)
}
