% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R, R/session.R
\name{server}
\alias{server}
\alias{mcp_server}
\alias{mcp_session}
\title{R as a server: Configure R-based tools with LLM-enabled apps}
\usage{
mcp_server(tools = NULL)

mcp_session()
}
\arguments{
\item{tools}{A list of tools created with \code{\link[ellmer:tool]{ellmer::tool()}} that will be
available from the server or a file path to an .R file that, when sourced,
will return a list of tools. Any list that could be passed to
\code{Chat$set_tools()} can be passed here. By default, the package won't serve
any tools other than those needed to communicate with interactive R sessions.}
}
\value{
\code{mcp_server()} and \code{mcp_session()} are both called primarily for side-effects.
\itemize{
\item \code{mcp_server()} blocks the R process it's called in indefinitely and isn't
intended for interactive use.
\item \code{mcp_session()} makes the interactive R session it's called in available to
MCP servers. It returns a promise via \code{\link[promises:promise]{promises::promise()}}.
}
}
\description{
\code{mcp_server()} implements a model context protocol server with arbitrary
R functions as its tools. Optionally, calling \code{mcp_session()} in an
interactive R session allows those tools to execute inside of that session.
}
\section{Configuration}{


\code{\link[=mcp_server]{mcp_server()}} should be configured with the MCP clients via the \code{Rscript}
command. For example, to use with Claude Desktop, paste the following in your
Claude Desktop configuration (on macOS, at
\code{file.edit("~/Library/Application Support/Claude/claude_desktop_config.json")}):

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "mcpServers": \{
    "r-mcptools": \{
      "command": "Rscript",
      "args": ["-e", "mcptools::mcp_server()"]
    \}
  \}
\}
}\if{html}{\out{</div>}}

Or, to use with Claude Code, you might type in a terminal:

\if{html}{\out{<div class="sourceCode bash">}}\preformatted{claude mcp add -s "user" r-mcptools Rscript -e "mcptools::mcp_server()"
}\if{html}{\out{</div>}}

\strong{mcp_server() is not intended for interactive use.}

The server interfaces with the MCP client. If you'd like tools to have access
to variables inside of an interactive R session, call
\code{mcp_session()} to make your R session available to the server.
Place a call to \code{mcptools::mcp_session()} in your \code{.Rprofile}, perhaps with
\code{usethis::edit_r_profile()}, to make every interactive R session you start
available to the server.

On Windows, you may need to configure the full path to the Rscript executable.
Examples for Claude Code on WSL and Claude Desktop on Windows are shown
at \url{https://github.com/posit-dev/mcptools/issues/41#issuecomment-3036617046}.
}

\examples{
# should only be run non-interactively, and will block the current R process
# once called.
if (identical(Sys.getenv("MCPTOOLS_CAN_BLOCK_PROCESS"), "true")) {
# to start a server with a tool to draw numbers from a random normal:
library(ellmer)

tool_rnorm <- tool(
  rnorm,
  "Draw numbers from a random normal distribution",
  n = type_integer("The number of observations. Must be a positive integer."),
  mean = type_number("The mean value of the distribution."),
  sd = type_number("The standard deviation of the distribution. Must be a non-negative number.")
)

mcp_server(tools = list(tool_rnorm))

# can also supply a file path as `tools`
readLines(system.file("example-ellmer-tools.R", package = "mcptools"))

mcp_server(tools = system.file("example-ellmer-tools.R", package = "mcptools"))
}

if (interactive()) {
  mcp_session()
}

}
\seealso{
\itemize{
\item The "R as an MCP server" vignette at
\code{vignette("server", package = "mcptools")} delves into further detail
on setup and customization.
\item These functions implement R as an MCP \emph{server}. To use R as an MCP \emph{client},
i.e. to configure tools from third-party MCP servers with ellmer chats, see
\code{\link[=mcp_tools]{mcp_tools()}}.
}
}
