% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_network.R
\name{mc_network}
\alias{mc_network}
\title{Create Interactive Network Visualization}
\usage{
mc_network(
  mcmodule,
  variate = 1,
  color_pal = NULL,
  color_by = NULL,
  legend = FALSE,
  inputs = FALSE
)
}
\arguments{
\item{mcmodule}{An mcmodule object}

\item{variate}{Integer specifying which variate to visualize (default: 1)}

\item{color_pal}{Custom color palette for nodes (optional)}

\item{color_by}{Column name to determine node colors (optional)}

\item{legend}{Show colors legend (optional)}

\item{inputs}{Show non-node inputs: data-sets, data-frames and columns (optional)}
}
\value{
An interactive visNetwork object with features:
\itemize{
\item Highlighting of connected nodes
\item Node selection and filtering by module
\item Directional arrows showing relationships
\item Hierarchical layout
\item Draggable nodes
}
}
\description{
Generates an interactive network visualization using visNetwork library. The visualization
includes interactive features for exploring model structure and relationships.
}
\examples{
\donttest{
network <- mc_network(mcmodule=imports_mcmodule)
}
}
