% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_S3_methods.R
\name{anova.mcglm}
\alias{anova.mcglm}
\title{Anova Tables}
\usage{
\method{anova}{mcglm}(object, ...)
}
\arguments{
\item{object}{an object of class \code{mcglm}, usually, a result of a
call to \code{mcglm()} function.}

\item{...}{additional arguments affecting the summary produced. Note
that there is no extra options for mcglm object class.}
}
\value{
A \code{data.frame} with Chi-square statistic to test the
    null hypothesis of a parameter, or a set of parameters, be
    zero. Degree of freedom (Df) and p-values.
    The Wald test based on the observed covariance matrix of
    the parameters is used.
}
\description{
Performs Wald tests of the significance for the linear
predictor components by response variables. This function is useful
for joint hypothesis tests of regression coefficients associated with
categorical covariates with more than two levels. It is not designed
for model comparison.
}
\examples{
x1 <- seq(-1, 1, l = 100)
x2 <- gl(5, 20)
beta <- c(5, 0, -2, -1, 1, 2)
X <- model.matrix(~ x1 + x2)
set.seed(123)
y <- rnorm(100, mean = X\%*\%beta, sd = 1)
data = data.frame("y" = y, "x1" = x1, "x2" = x2)
fit.anova <- mcglm(c(y ~ x1 + x2), list(mc_id(data)), data = data)
anova(fit.anova)

}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}

