% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{predict.cv.mcen}
\alias{predict.cv.mcen}
\title{Makes predictions from the model with the smallest cross-validation error.}
\usage{
\method{predict}{cv.mcen}(object, newx, ...)
}
\arguments{
\item{object}{The cv.mcen object.}

\item{newx}{The X matrix of predictors.}

\item{...}{Additional parameters to be sent to predict.}
}
\value{
Returns the predicted values from the model with the smallest cross-validation error.
}
\description{
Makes predictions from the model with the smallest cross-validation error.
}
\examples{
\donttest{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
mcen_fit <- cv.mcen(x,y,ky=2,gamma_y=3)
new_x <- matrix(rnorm(12),ncol=4)
mcen_preds <- predict(mcen_fit, new_x)
}
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
