% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_grid_to_polygons.R
\name{aggregate_raster_to_polygons}
\alias{aggregate_raster_to_polygons}
\title{Aggregate a raster to polygons}
\usage{
aggregate_raster_to_polygons(
  data_raster,
  aggregation_table,
  aggregation_cols = "polygon_id",
  method = "mean",
  aggregated_field = "data",
  z_dimension = NULL,
  z_dimension_name = "z",
  weighting_raster = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{data_raster}{\link[terra:SpatRaster-class]{terra::SpatRaster} containing data to be aggregated to polygons.}

\item{aggregation_table}{\link[data.table:data.table]{data.table::data.table} Aggregation table linking pixels to
polygon identifiers, created using \code{build_aggregation_table()}}

\item{aggregation_cols}{(character vector, default 'polygon_id') Polygon identifiers
to use for aggregation. Must be field names within \code{aggregation_table}.}

\item{method}{(character, default 'mean') Aggregation method: one of 'mean', 'sum',
'weighted.mean', or 'weighted.sum'. The latter two methods require a
\code{weighting_raster.}}

\item{aggregated_field}{(character, default 'data') Name of the aggregated raster
values in the output table.}

\item{z_dimension}{(vector, default NULL) If passing a \code{data_raster} with multiple
layers, how should each layer be identified? Should be a vector with length equal to
the number of layers in \code{data_raster}. If left as \code{NULL}, the default, and
\code{data_raster} has 1 layer, no z dimension will be added. If left as \code{NULL} and
\code{data_raster} has more than 1 layer, will default to (1, 2, ..., N layers).}

\item{z_dimension_name}{(default 'z') The field name for the "z" dimension
corresponding to each layer of the \code{data_raster}. This field is only added if
\code{z_dimension} is passed or if \code{data_raster} has more than one layer.}

\item{weighting_raster}{(\link[terra:SpatRaster-class]{terra::SpatRaster}, default NULL) The relative weighting of
each whole pixel to the overall polygon value, for example, if calculating a
population-weighted mean. Required for methods 'weighted.mean' and 'weighted.sum',
ignored for the other methods.}

\item{na.rm}{(bool, default TRUE) How to handle NA pixels in \code{data_raster} and
\code{weighting_raster}. If set to TRUE but ALL pixels in a polygon are NA, will still
return an NA value for the polygon.}
}
\value{
data.table containing polygon identifiers, (optionally) layer identifiers in
the \code{z_dimension_name} column, and data values aggregated by polygon.
}
\description{
Aggregate raster values to polygons using an aggregation table
}
\details{
This is a more efficient and feature-rich alternative to terra's zonal
statistics functions. Features include:
\itemize{
\item Always fractionally aggregate, weighting by area of the pixel in a polygon
\item Optionally weight by both area fraction and a weighting raster (e.g. population)
\item Means or sums of raster values across polygons
\item Optionally aggregate multiple years of raster data at once
}
}
\examples{
\dontrun{
  polygons <- sf::st_read(system.file('extdata/Benin_communes.gpkg', package = 'mbg'))
  id_raster <- build_id_raster(polygons)
  n_data_pixels <- sum(!is.na(terra::values(id_raster)))
  # Example ID raster filled with data
  # This is an example of pixel-level covariate data or model estimates
  data_raster <- mbg::values_to_raster(stats::rnorm(n_data_pixels), id_raster)
  # Build aggregation table, which can be used across many aggregations
  aggregation_table <- build_aggregation_table(
    polygons, id_raster, polygon_id_field = 'commune_code'
  )
  # Aggregate the raster to the polygons
   aggregated <- aggregate_raster_to_polygons(
     data_raster = data_raster,
     aggregation_table = aggregation_table,
     aggregation_cols = 'commune_code',
     method = 'mean'
   )
   head(aggregated)
}

}
\seealso{
build_aggregation_table
}
\concept{aggregation}
