% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{getzerorowcolnames_byname}
\alias{getzerorowcolnames_byname}
\title{Names of zero rows and columns}
\usage{
getzerorowcolnames_byname(a, tol = 1e-06)
}
\arguments{
\item{a}{A matrix or list of matrices.}

\item{tol}{The allowable deviation from 0 for any element.}
}
\value{
A vector of names of zero rows or columns.
}
\description{
When a matrix has rows or columns full of zeroes,
it is singular, and can't be inverted.
This function returns the names of rows or columns that are full with zeroes.
}
\examples{
m <- matrix(c(1, 0, 1,
              1, 0, 0, 
              0, 0, 0),
            dimnames = list(c("r1", "r2", "r3"), c("c1", "c2", "c3")), 
            nrow = 3, ncol = 3, byrow = TRUE)
m
getzerorowcolnames_byname(m)
}
