% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{rowsums_byname}
\alias{rowsums_byname}
\title{Row sums, sorted by name}
\usage{
rowsums_byname(a, colname = NA)
}
\arguments{
\item{a}{a matrix or list of matrices from which row sums are desired.}

\item{colname}{name of the output column containing row sums}
}
\value{
a column vector of type \code{matrix} containing the row sums of \code{m}
}
\description{
Calculates row sums for a matrix by post-multiplying by an identity vector (containing all 1's).
In contrast to \code{rowSums} (which returns a \code{numeric} result),
the return value from \code{rowsums_byname} is a matrix.
An optional \code{colname} for the resulting column vector can be supplied.
If \code{colname} is \code{NULL} or \code{NA} (the default),
the column name is set to the column type as given by \code{coltype(a)}.
}
\examples{
library(dplyr)
m <- matrix(c(1:6), ncol = 2, dimnames = list(paste0("i", 3:1), paste0("c", 1:2))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
rowsums_byname(m)
rowsums_byname(m, "E.ktoe")
# This also works with lists
rowsums_byname(list(m, m))
rowsums_byname(list(m, m), "E.ktoe")
rowsums_byname(list(m, m), NA)
rowsums_byname(list(m, m), NULL)
DF <- data.frame(m = I(list()))
DF[[1,"m"]] <- m
DF[[2,"m"]] <- m
rowsums_byname(DF$m[[1]])
rowsums_byname(DF$m)
ans <- DF \%>\% mutate(rs = rowsums_byname(m))
ans
ans$rs[[1]]
# Nonsensical
\dontrun{rowsums_byname(NULL)}
}
