% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{kvec_from_template_byname}
\alias{kvec_from_template_byname}
\title{Create a constant vector from matrix \code{a}}
\usage{
kvec_from_template_byname(a, k = 1, colname = NA, column = TRUE)
}
\arguments{
\item{a}{The template matrix for the column vector.}

\item{k}{The value of the entries in the vector.}

\item{colname}{The name of the output vector's 1-sized dimension
(the only column if \code{column == TRUE}, the only row otherwise).}

\item{column}{Tells whether a column vector (\code{TRUE}, the default) or a row vector (\code{FALSE}) should be created.}
}
\value{
A vector vector formed from \code{a}.
}
\description{
This function creates a vector using \code{a} as a template
and \code{k} as its value.
Row names are taken from the row names of \code{a}.
The column name is given by \code{colname}.
Row and column types are transferred from \code{a} to the output, directly.
}
\details{
If \code{column == FALSE}, \code{colname} is interpreted as the row name for the output row identity vector.
}
\examples{
kvec_from_template_byname(matrix(42, nrow = 4, ncol = 2,
                                 dimnames = list(c("r1", "r2", "r3", "r4"), c("c1", "c2"))), 
                          colname = "c1")
}
