% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.R
\name{cumapply_byname}
\alias{cumapply_byname}
\title{Apply a function cumulatively to a list of matrices or numbers}
\usage{
cumapply_byname(FUN, a)
}
\arguments{
\item{FUN}{the function to be applied}

\item{a}{the list of matrices or numbers to which \code{FUN} will be applied cumulatively}
}
\value{
a list of same length as \code{a}
containing the cumulative application of \code{FUN} to \code{a}
}
\description{
\code{FUN} must be a binary function that also accepts a single argument.
The result is a list with first element \code{FUN(a[[1]])}.
For \code{i >= 2}, elements are \code{FUN(a[[i]], out[[i-1]])},
where \code{out} is the result list.
}
\details{
\code{\link{naryapply_byname}} and \code{\link{cumapply_byname}} are similar.
Their differences can be described by considering a data frame.
\code{\link{naryapply_byname}} applies \code{FUN} to several columns (variables) of the data frame.
For example, \code{\link{sum_byname}} applied to several variables gives another column
containing the sums across each row of the data frame.
\code{\link{cumapply_byname}} applies \code{FUN} to successive entries in a single column.
For example \code{\link{sum_byname}} applied to a single column gives the sum of all numbers in that column.
}
\examples{
cumapply_byname(sum, list(1, 2, 3, 4))
cumapply_byname(sum_byname, list(1, 2, 3, 4))
cumapply_byname(prod, list(1, 2, 3, 4))
cumapply_byname(hadamardproduct_byname, list(1, 2, 3, 4))
}
