% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{compare_byname}
\alias{compare_byname}
\title{Compare matrix entries to a value}
\usage{
compare_byname(a, compare_fun = c("==", "!=", "<", "<=", ">=", ">"),
  val = 0)
}
\arguments{
\item{a}{a matrix or list of matrices whose values are to be counted according to \code{compare_fun}}

\item{compare_fun}{the comparison function, one of "\code{==}", "\code{!=}", 
"\code{<}", "\code{<=}", "\code{>=}", or "\code{>}". Default is "\code{==}".}

\item{val}{a single value against which entries in matrix \code{a} are compared. Default is \code{0}.}
}
\value{
a logical matrix of same size as \code{a} containing \code{TRUE} where the criterion is met,
        \code{FALSE} otherwise
}
\description{
Compares matrix entries to a value, 
returning a matrix of same size as \code{a}
containing \code{TRUE} or \code{FALSE} values
as the result of applying \code{compare_fun} and \code{val}
to all entries in \code{a}.
}
\examples{
m <- matrix(c(0, 1, 2, 3, 4, 0), nrow = 3, ncol = 2)
compare_byname(m, "<", 3)
compare_byname(list(m,m), "<", 3)
}
