% Generated by roxygen2 (4.0.2): do not edit by hand
\name{weight.fixed}
\alias{weight.fixed}
\title{Fixed weights}
\usage{
weight.fixed(S, model, W.mod = NULL, ..., standardize = TRUE)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{W.mod}{An optional numeric matrix representing the weight patter and starting weights
(i.e. the how the indicators are combined to form the composite variables). If this argument is not specified,
the weight patter is defined based on the relationships in the \code{reflective} and  \code{formative}
elements of \code{model}.}

\item{...}{All other arguments are ignored.}

\item{standardize}{\code{TRUE} (default) or \code{FALSE} indicating whether S should be converted
to a correlation matrix.}
}
\value{
An object of class \code{"matrixplsweights"}, which is a matrix containing the weights with the following attributes:

\item{iterations}{Number of iterations performed}

\item{converged}{A boolean indicating if the algorithm converged}

\item{history}{A data.frame containing the weights for each iteration}
}
\description{
Returns fixed weights
}
\details{
Returns the starting weights specified
in \code{W.mod}. If \code{standardize} is \code{TRUE} the weights are
standardized so that the composites have unit variances.


Model can be specified in the lavaan format or the native matrixpls format.
The native model format is a list of three binary matrices, \code{inner}, \code{reflective},
and \code{formative} specifying the free parameters of a model: \code{inner} (\code{l x l}) specifies the
regressions between composites, \code{reflective} (\code{k x l}) specifies the regressions of observed
data on composites, and \code{formative} (\code{l x k}) specifies the regressions of composites on the
observed data. Here \code{k} is the number of observed variables and \code{l} is the number of composites.

If the model is specified in lavaan format, the native
format model is derived from this model by assigning all regressions between latent
variables to \code{inner}, all factor loadings to \code{reflective}, and all regressions
of latent variables on observed variables to \code{formative}. Regressions between
observed variables and all free covariances are ignored. All parameters that are
specified in the model will be treated as free parameters. If model is specified in
lavaan syntax, the model that is passed to the \code{parameterEstimator} will be that
model and not the native format model.

The original papers about Partial Least Squares, as well as many of the current PLS
implementations, impose restrictions on the matrices \code{inner},
\code{reflective}, and \code{formative}: \code{inner} must be a lower triangular matrix,
\code{reflective} must have exactly one non-zero value on each row and must have at least
one non-zero value on each column, and \code{formative} must only contain zeros.
Some PLS implementations allow \code{formative} to contain non-zero values, but impose a
restriction that the sum of \code{reflective} and \code{t(formative)} must satisfy
the original restrictions of \code{reflective}. The only restrictions that matrixpls
imposes on \code{inner}, \code{reflective}, and \code{formative} is that these must be
binary matrices and that the diagonal of \code{inner} must be zeros.


The argument \code{W.mod} is a (\code{l x k}) matrix that indicates
how the indicators are combined to form the composites. The original papers about
Partial Least Squares as well as all current PLS implementations define this as
\code{t(reflective) | formative}, which means that the weight patter must match the
model specified in \code{reflective} and \code{formative}. Matrixpls does not
require that \code{W.mod} needs to match \code{reflective} and \code{formative}, but
accepts any numeric matrix. If this argument is not specified, \code{W.mod} is
defined as \code{t(reflective) | formative}.
}
\seealso{
Other Weight algorithms: \code{\link{weight.optim}};
  \code{\link{weight.pls}}
}

