# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Default size of the steps in the RK
#' 
#' Computes the default step length for a matrix \code{S} to be employed in the RK method
#' @param S sub-intensity matrix
#' @return The step length for \code{S}
#' 
default_step_length <- function(S) {
    .Call(`_matrixdist_default_step_length`, S)
}

#' Runge Kutta for the calculation of the a,b and c vectors in a EM step
#' 
#' Performce the RK of forth order
#' @param avector the a vector
#' @param bvector the b vector 
#' @param cmatrix the c matrix
#' @param dt the increment
#' @param h step-length
#' @param S sub-intensity
#' @param t exit rates 
#' 
runge_kutta <- function(avector, bvector, cmatrix, dt, h, S, t) {
    invisible(.Call(`_matrixdist_runge_kutta`, avector, bvector, cmatrix, dt, h, S, t))
}

#' EM step using Runge Kutta
#' 
#' Computes one step of the EM algorithm by using a Runge-Kutta method of 4th order
#' @param h step-length
#' @param alpha initial probalities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight the weights for the observations
#' @param rcens censored observations
#' @param rcweight the weights for the censored observations
#' 
EMstep_RK <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    invisible(.Call(`_matrixdist_EMstep_RK`, h, alpha, S, obs, weight, rcens, rcweight))
}

#' Runge Kutta for the calculation of the a vectors in a EM step 
#' 
#' Can be used for the loglikelihood
#' @param avector the a vector
#' @param dt increment
#' @param h step-length
#' @param S sub-intensity
#' 
a_rungekutta <- function(avector, dt, h, S) {
    invisible(.Call(`_matrixdist_a_rungekutta`, avector, dt, h, S))
}

#' Loglikelihood using RK
#' 
#' Loglikelihood for a sample 
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodPH_RK <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodPH_RK`, h, alpha, S, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix Weibull using RK
#' 
#' Loglikelihood for a sample 
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMweibull_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMweibull_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix Pareto using RK
#' 
#' Loglikelihood for a sample 
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMpareto_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMpareto_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix LogNormal using RK
#' 
#' Loglikelihood for a sample 
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMlognormal_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMlognormal_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix Log-Logistic using RK
#' 
#' Loglikelihood for a sample 
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMloglogistic_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix Gompertz using RK
#' 
#' Loglikelihood for a sample 
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMgompertz_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgompertz_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix GEV using RK
#' 
#' Loglikelihood for a sample 
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMgev_RK <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgev_RK`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Applies the inverse of the GEV but giving back the vector in reverse order
#' 
#' Used for EM step
#' @param observations the observations
#' @param weights weithgs of the observations
#' @param beta parameters of the GEV
#' 
reversTransformData <- function(observations, weights, beta) {
    .Call(`_matrixdist_reversTransformData`, observations, weights, beta)
}

#' Derivative of matrix Weibull
#' 
#' Can be used to increase performance
#' @param h step-length
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
derivativeMatrixweibull <- function(h, obs, weight, rcens, rcweight, alpha, S, beta) {
    .Call(`_matrixdist_derivativeMatrixweibull`, h, obs, weight, rcens, rcweight, alpha, S, beta)
}

#' Loglikelihood of PH using RK
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodPH_RKs <- function(h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodPH_RKs`, h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Weibull using RK
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMweibull_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMweibull_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Pareto using RK
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMpareto_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMpareto_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-lognormal using RK
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMlognormal_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMlognormal_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-loglogistic using RK
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMloglogistic_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Gompertz using RK
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMgompertz_RKs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMgompertz_RKs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Computes elements S^n / n! until the value size
#' @param theVector a vector
#' @param S sub-untensity matrix
#' @param sizevect size of vector
vectorOfMatrices_arma2 <- function(theVector, S, sizevect) {
    invisible(.Call(`_matrixdist_vectorOfMatrices_arma2`, theVector, S, sizevect))
}

#' EM using Matlab algorithm for matrix exponential in combination with Armadillo
#' 
#' @param h nuisance parameter
#' @param alpha initial probalities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight the weights for the observations
#' @param rcens censored observations
#' @param rcweight the weights for the censored observations
#' 
EMstep_PADE <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    invisible(.Call(`_matrixdist_EMstep_PADE`, h, alpha, S, obs, weight, rcens, rcweight))
}

#' Loglikelihood of PH using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodPH_PADE <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodPH_PADE`, h, alpha, S, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Weibull using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMweibull_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMweibull_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Pareto using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMpareto_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMpareto_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-lognormal using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMlognormal_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMlognormal_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-loglogistic using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMloglogistic_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Gompertz using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMgompertz_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgompertz_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-GEV using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMgev_PADE <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgev_PADE`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of PH using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodPH_PADEs <- function(h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodPH_PADEs`, h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Weibull using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMweibull_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMweibull_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Pareto using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMpareto_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMpareto_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-lognormal using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMlognormal_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMlognormal_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-loglogistic using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMloglogistic_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Gompertz using Pade
#' 
#' Loglikelihood for a sample 
#' @param h nuisance parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta in-homogeneity parameter
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMgompertz_PADEs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMgompertz_PADEs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Computes elements S^n / n! until the value size
#' @param theVector a vector
#' @param S sub-untensity matrix
#' @param a a number
#' @param sizevect size of vector
vectorOfMatrices_arma <- function(theVector, S, a, sizevect) {
    invisible(.Call(`_matrixdist_vectorOfMatrices_arma`, theVector, S, a, sizevect))
}

#' Computes e^(Sx) base on the values on powerVector
#' @param x a number
#' @param n an integer
#' @param powerVector a vector
#' @param a a number
matrixExpSum_arma <- function(x, n, powerVector, a) {
    .Call(`_matrixdist_matrixExpSum_arma`, x, n, powerVector, a)
}

pow2Matrix_arma <- function(n, A) {
    invisible(.Call(`_matrixdist_pow2Matrix_arma`, n, A))
}

#' EM using Uniformization for matrix exponential
#' 
#' @param h positive parameter
#' @param alpha initial probalities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight the weights for the observations
#' @param rcens censored observations
#' @param rcweight the weights for the censored observations
#' 
EMstep_UNI <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    invisible(.Call(`_matrixdist_EMstep_UNI`, h, alpha, S, obs, weight, rcens, rcweight))
}

#' Loglikelihood using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodPH_UNI <- function(h, alpha, S, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodPH_UNI`, h, alpha, S, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Weibull using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMweibull_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMweibull_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Pareto using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMpareto_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMpareto_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-lognormal using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMlognormal_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMlognormal_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-loglogistic using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMloglogistic_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-Gompertz using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMgompertz_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgompertz_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of matrix-GEV using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' 
logLikelihoodMgev_UNI <- function(h, alpha, S, beta, obs, weight, rcens, rcweight) {
    .Call(`_matrixdist_logLikelihoodMgev_UNI`, h, alpha, S, beta, obs, weight, rcens, rcweight)
}

#' Loglikelihood of PH using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodPH_UNIs <- function(h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodPH_UNIs`, h, alpha, S, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Weibull using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMweibull_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMweibull_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Pareto using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMpareto_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMpareto_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-lognormal using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMlognormal_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMlognormal_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-loglogistic using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMloglogistic_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMloglogistic_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Loglikelihood of matrix-Gompertz using Uniformization
#' 
#' Loglikelihood for a sample 
#' @param h positive parameter
#' @param alpha initial probabilities
#' @param S sub-intensity
#' @param beta parameter of transformation
#' @param obs the observations
#' @param weight weight of the observations
#' @param rcens censored observations
#' @param rcweight weight of the censored observations
#' @param scale1 scale for observations
#' @param scale2 scale for censored observations
#' 
logLikelihoodMgompertz_UNIs <- function(h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2) {
    .Call(`_matrixdist_logLikelihoodMgompertz_UNIs`, h, alpha, S, beta, obs, weight, rcens, rcweight, scale1, scale2)
}

#' Embedded Markov chain of a sub-intensity matrix
#' 
#' Returns the transition probabilities of the embedded Markov chain determined the sub-intensity matrix 
#' @param S A sub-intensity matrix
#' @return The embedded Markov chain
#' 
embeddedMC <- function(S) {
    .Call(`_matrixdist_embeddedMC`, S)
}

#' Cumulate matrix
#' 
#' Creates a new matrix with entries the cumulated rows of \code{A}
#' @param A A matrix
#' @return The cumulated matrix
cumulateMatrix <- function(A) {
    .Call(`_matrixdist_cumulateMatrix`, A)
}

#' Cumulate vector
#' 
#' Creates a new vector with entries the cumulated entries of \code{A}
#' @param A A vector
#' @return The cumulated vector
cumulateVector <- function(A) {
    .Call(`_matrixdist_cumulateVector`, A)
}

#' Initial state of Markov jump process
#' 
#' Given the accumulated values of the initial probabilities \code{Pi} and a uniform value \code{u}, it returns the initial state of a Markov jump process
#' @param cumulatedPi A vector
#' @param u A random value in (0,1)
#' @return The initial state of the Markov jump process
initialState <- function(cumulatedPi, u) {
    .Call(`_matrixdist_initialState`, cumulatedPi, u)
}

#' New state in a Markov jump process
#' 
#' Given a transition matrix \code{Q}, a uniform value \code{u}, and a previous state \code{k}, it returns the new state of a Markov jump process
#' @param previousState Previous state of the Markov jump process
#' @param cumulatedEmbeddedMC A transition matrix
#' @param u A random value in (0,1)
#' @return The next state of the Markov jump process
newState <- function(previousState, cumulatedEmbeddedMC, u) {
    .Call(`_matrixdist_newState`, previousState, cumulatedEmbeddedMC, u)
}

#' Random phase-type
#' 
#' Generates a sample of size \code{n} from a phase-type distribution with parameters \code{alpha} and \code{S}
#' @param n Sample size
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @return The simulated sample
#' 
rphasetype <- function(n, alpha, S) {
    .Call(`_matrixdist_rphasetype`, n, alpha, S)
}

#' Random inhomogeneous phase-type
#' 
#' Generates a sample of size \code{n} from an inhomogeneous phase-type distribution with parameters \code{alpha}, \code{S} and \code{beta}
#' @param n Sample size
#' @param dist_type Type of IPH
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta Parameter of the transformation
#' @return The simulated sample
#' 
riph <- function(n, dist_type, alpha, S, beta) {
    .Call(`_matrixdist_riph`, n, dist_type, alpha, S, beta)
}

#' Random matrix GEV
#' 
#' Generates a sample of size \code{n} from an inhomogeneous phase-type distribution with parameters \code{alpha}, \code{S} and \code{beta}
#' @param n Sample size
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param mu Location parameter
#' @param sigma Scale parameter
#' @param xi Shape parameter: Default 0 which corresponds to the Gumbel case
#' @return The simulated sample
#' 
rmatrixgev <- function(n, alpha, S, mu, sigma, xi = 0) {
    .Call(`_matrixdist_rmatrixgev`, n, alpha, S, mu, sigma, xi)
}

LInf_normArma <- function(A) {
    .Call(`_matrixdist_LInf_normArma`, A)
}

#' Creates the matrix  (A1, B1 ; 0, A2)
#' @param A1 matrix
#' @param A2 matrix
#' @param B1 matrix
#' @return Computes (A1, B1 ; 0, A2)
#' 
matrix_VanLoanArma <- function(A1, A2, B1) {
    .Call(`_matrixdist_matrix_VanLoanArma`, A1, A2, B1)
}

matrixMaxDiagonal_arma <- function(A) {
    .Call(`_matrixdist_matrixMaxDiagonal_arma`, A)
}

#' Phase-type density
#' 
#' Computes the density of phase-type distribution with parameters \code{alpha} and \code{S} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @return The density at \code{x}
#' 
phdensity <- function(x, alpha, S) {
    .Call(`_matrixdist_phdensity`, x, alpha, S)
}

#' Phase-type cdf or tail
#' 
#' Computes the cdf of phase-type distribution with parameters \code{alpha} and \code{S} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param lower_tail cdf or tail
#' @return The cdf (tail) at \code{x}
#' 
phcdf <- function(x, alpha, S, lower_tail = TRUE) {
    .Call(`_matrixdist_phcdf`, x, alpha, S, lower_tail)
}

#' Matrix Weibull density
#' 
#' Computes the density of a matrix Weibull distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta shape parameter
#' @return The density at \code{x}
#' 
mweibullden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mweibullden`, x, alpha, S, beta)
}

#' Matrix Weibull cdf
#' 
#' Computes the cdf (tail) of a matrix Weibull distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta shape parameter
#' @param lower_tail cdf or tail
#' @return The cdf (tail) at \code{x}
#' 
mweibullcdf <- function(x, alpha, S, beta, lower_tail) {
    .Call(`_matrixdist_mweibullcdf`, x, alpha, S, beta, lower_tail)
}

RunFunction <- function(a, func) {
    .Call(`_matrixdist_RunFunction`, a, func)
}

#' Matrix Pareto density
#' 
#' Computes the density of a matrix Pareto distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta scale parameter
#' @return The density at \code{x}
#' 
mparetoden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mparetoden`, x, alpha, S, beta)
}

#' Matrix Pareto cdf
#' 
#' Computes the cdf (tail) of a matrix Pareto distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta shape parameter
#' @param lower_tail cdf or tail
#' @return The cdf (tail) at \code{x}
#' 
mparetocdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mparetocdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix LogNormal density
#' 
#' Computes the density of a matrix LogNormal distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta shape parameter
#' @return The density at \code{x}
#' 
mlognormalden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mlognormalden`, x, alpha, S, beta)
}

#' Matrix LogNormal cdf
#' 
#' Computes the cdf (tail) of a matrix LogNormal distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta shape parameter
#' @param lower_tail cdf or tail
#' @return The cdf (tail) at \code{x}
#' 
mlognormalcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mlognormalcdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix Log-Logistic density
#' 
#' Computes the density of a matrix Log-Logistic distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta scale parameter
#' @return The density at \code{x}
#' 
mloglogisticden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mloglogisticden`, x, alpha, S, beta)
}

#' Matrix Log-Logistic cdf
#' 
#' Computes the cdf (tail) of a matrix Log-Logistic distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta shape parameter
#' @param lower_tail cdf or tail
#' @return The cdf (tail) at \code{x}
#' 
mloglogisticcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mloglogisticcdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix Gompertz density
#' 
#' Computes the density of a matrix Gompertz distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta parameter
#' @return The density at \code{x}
#' 
mgompertzden <- function(x, alpha, S, beta) {
    .Call(`_matrixdist_mgompertzden`, x, alpha, S, beta)
}

#' Matrix Gompertz cdf
#' 
#' Computes the cdf (tail) of a matrix Gompertz distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param beta shape parameter
#' @param lower_tail cdf or tail
#' @return The cdf (tail) at \code{x}
#' 
mgompertzcdf <- function(x, alpha, S, beta, lower_tail = TRUE) {
    .Call(`_matrixdist_mgompertzcdf`, x, alpha, S, beta, lower_tail)
}

#' Matrix GEV density
#' 
#' Computes the density of a matrix GEV distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' Dont allow for atoms in zero
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param mu  location parameter
#' @param sigma scale parameter
#' @param xi shape parameter
#' @return The density at \code{x}
#' 
mgevden <- function(x, alpha, S, mu, sigma, xi) {
    .Call(`_matrixdist_mgevden`, x, alpha, S, mu, sigma, xi)
}

#' Matrix GEV cdf
#' 
#' Computes the cdf (tail) of a matrix GEV distribution with parameters \code{alpha}, \code{S} and \code{beta} at \code{x}
#' @param x non-negative value
#' @param alpha Initial probabilities
#' @param S sub-intensity matrix
#' @param mu  location parameter
#' @param sigma scale parameter
#' @param xi shape parameter
#' @param lower_tail cdf or tail
#' @return The cdf (tail) at \code{x}
#' 
mgevcdf <- function(x, alpha, S, mu, sigma, xi, lower_tail = TRUE) {
    .Call(`_matrixdist_mgevcdf`, x, alpha, S, mu, sigma, xi, lower_tail)
}

#' Product of two matrices
#' @param A1 matrix
#' @param A2 matrix
#' @return Computes C = A1 * A2
#' 
matrix_product <- function(A1, A2) {
    .Call(`_matrixdist_matrix_product`, A1, A2)
}

sumArma_0 <- function(A1, A2) {
    .Call(`_matrixdist_sumArma_0`, A1, A2)
}

#' Inverse of a matrix
#' 
#' Computes the inverse
#' @param A a matrix
#' 
matrix_inverse <- function(A) {
    .Call(`_matrixdist_matrix_inverse`, A)
}

LInf_normArma_0 <- function(A) {
    .Call(`_matrixdist_LInf_normArma_0`, A)
}

#' Matrix exponential algorithm
#' 
#' MATLAB's built-in algorithm - Pade approximation
#' @param Ainput a matrix
#' 
matrix_exponential <- function(Ainput) {
    .Call(`_matrixdist_matrix_exponential`, Ainput)
}

#' Product of two matrices
#' @param a matrix
#' @param b matrix
#' @return Computes c = a * b
#' 
matrix_product_slow <- function(a, b) {
    .Call(`_matrixdist_matrix_product_slow`, a, b)
}

#' Add matrices
#' 
#' Computes C =  A + B 
#' @param A A matrix
#' @param B A matrix
#' 
matrix_sum <- function(A, B) {
    .Call(`_matrixdist_matrix_sum`, A, B)
}

#' L-oo norm of a matrix
#' 
#' Computes the L-oo norm of a matrix \code{A}, which is defined as:
#' L-oo A =  max ( 1 <= I <= M ) sum ( 1 <= J <= N ) abs ( A(I,J) ).
#' @param A A matrix
LInf_norm <- function(A) {
    .Call(`_matrixdist_LInf_norm`, A)
}

#' Solves a system with multiple right hand sides
#' 
#' AX=B which can be decomposed as LUX=B and finds X.
#' When B is the identity matrix the solution is the inverse of A
#' @param A1 a matrix
#' @param B a matrix
#' 
solve_linear_system <- function(A1, B) {
    .Call(`_matrixdist_solve_linear_system`, A1, B)
}

#' Inverse of a matrix
#' 
#' Computes the inverse
#' @param A a matrix
#' 
matrix_inverse_slow <- function(A) {
    .Call(`_matrixdist_matrix_inverse_slow`, A)
}

#' Matrix exponential algorithm
#' 
#' MATLAB's built-in algorithm - Pade approximation
#' @param A a matrix
#' 
matrix_exponential_slow <- function(A) {
    .Call(`_matrixdist_matrix_exponential_slow`, A)
}

#' Maximum entry in a matrix
#' 
#' Find the maximum entry
#' @param A a matrix
#' 
matrixMax <- function(A) {
    .Call(`_matrixdist_matrixMax`, A)
}

#' Maximum entry in the diagonal of a matrix
#' 
#' @param A a matrix
matrixMaxDiagonal <- function(A) {
    .Call(`_matrixdist_matrixMaxDiagonal`, A)
}

#' Computes A^n
#' 
#' @param n integer
#' @param A a matrix
#' 
matrix_power <- function(n, A) {
    .Call(`_matrixdist_matrix_power`, n, A)
}

#' Clone a vector 
#' 
#' @param v a vector
#' 
clone_vector <- function(v) {
    .Call(`_matrixdist_clone_vector`, v)
}

#' Clone a matrix 
#' 
#' @param m a matrix
#' 
clone_matrix <- function(m) {
    .Call(`_matrixdist_clone_matrix`, m)
}

#' Creates the matrix  (A1, B1 ; 0, A2)
#' 
#' @param A1 a matrix
#' @param A2 a matrix
#' @param B1 a matrix
#' 
matrix_VanLoan <- function(A1, A2, B1) {
    .Call(`_matrixdist_matrix_VanLoan`, A1, A2, B1)
}

#' Creates a matrix with the given vector in the diagonal
#' 
#' @param vec a vector
#' 
diagonal_vector <- function(vec) {
    .Call(`_matrixdist_diagonal_vector`, vec)
}

#' Computes the initial distribution and sub-intensity of the sum of PH
#' 
#' @param alpha1 initial distribution
#' @param S1 sub-intensity
#' @param alpha2 initial distribution
#' @param S2 sub-intensity
#' 
sumPH <- function(alpha1, S1, alpha2, S2) {
    .Call(`_matrixdist_sumPH`, alpha1, S1, alpha2, S2)
}

#' Random structure of a phase-type
#' 
#' Generates random parameters \code{alpha} and \code{S} of a phase-type distribution of dimension \code{p} with chosen structure
#' @param p Dimension of the phase-type
#' @param structure Type of structure: "general", "hyperexponential", "gerlang", "coxian" or "gcoxian"
#' @param scale_factor A factor that multiplies the sub-intensity matrix
#' @return Random parameters \code{alpha} and \code{S} of a phase-type
#' 
random_structure <- function(p, structure = "general", scale_factor = 1) {
    .Call(`_matrixdist_random_structure`, p, structure, scale_factor)
}

