% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneway.R
\name{oneway}
\alias{oneway}
\alias{row_oneway_equalvar}
\alias{col_oneway_equalvar}
\alias{row_oneway_welch}
\alias{col_oneway_welch}
\title{ONEWAY ANOVA}
\usage{
row_oneway_equalvar(x, g)

col_oneway_equalvar(x, g)

row_oneway_welch(x, g)

col_oneway_welch(x, g)
}
\arguments{
\item{x}{numeric matrix.}

\item{g}{a vector specifying group membership for each observation of x.}
}
\value{
a data.frame where each row contains the results of an oneway anova
test performed on the corresponding row/column of x.
The columns will vary depending on the type of test performed.\cr\cr
They will contain a subset of the following information:\cr
1. obs.tot - total number of observations\cr
2. obs.groups - number of groups\cr
3. sumsq.between - between group (treatment) sum of squares\cr
4. sumsq.within - within group (residual) sum of squares\cr
5. meansq.between - between group mean squares\cr
6. meansq.within - within group mean squares\cr
7. df.between - between group (treatment) degrees of freedom\cr
8. df.within - within group (residual) degrees of freedom\cr
9. statistic - F statistic\cr
10. pvalue - p.value
}
\description{
Performs an analysis of variance tests on each row/column of the input matrix.
}
\details{
Functions to perform ONEWAY ANOVA analysis for rows/columns of matrices.

\code{row_oneway_equalvar}, \code{col_oneway_equalvar}
- one-way anova on columns. Same as \code{aov(x ~ group)}

\code{row_oneway_welch}, \code{col_oneway_welch}
- one-way anova with Welch correction on columns. Same as \code{oneway.test(var.equal=FALSE)}
}
\examples{
col_oneway_welch(iris[,1:4], iris$Species)
row_oneway_equalvar(t(iris[,1:4]), iris$Species)

}
\seealso{
\code{aov()}, \code{oneway.test()}
}
\author{
Karolis Koncevičius
}
