% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matlib.R
\name{proj}
\alias{proj}
\title{Projection of Vector y on columns of X}
\usage{
proj(y, X)
}
\arguments{
\item{y}{a vector, treated as a one-column matrix}

\item{X}{a vector or matrix.  Number of rows of \code{y} and \code{X} must match}
}
\value{
the projection of y on X
}
\description{
Fitting a linear model, \code{y ~ X}, by least squares can be thought of geometrically as the projection of
\code{y} on the column space of \code{X}.  This function is designed to allow exploration of projections
and orthogonality.
}
\examples{
X <- matrix( c(1, 1, 1, 1, 1, -1, 1, -1), 4,2, byrow=TRUE)
y <- 1:4
proj(y, X[,1])  # project y on unit vector
proj(y, X[,2])
proj(y, X)
}

