/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.cp.solver.constraints.integer.extension.FastBooleanValidityChecker;
import choco.cp.solver.constraints.integer.extension.FastValidityChecker;
import choco.cp.solver.constraints.integer.extension.ValidityChecker;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesList;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class GACstrPositiveLargeSConstraint
extends CspLargeSConstraint {
    protected TuplesList relation;
    protected ValidityChecker valcheck;
    protected int arity;
    protected int[] offsets;
    protected List<Integer> futureVars;
    protected BitSet[] gacValues;
    protected int[] nbGacValues;
    protected IStateIntVector ltuples;

    public GACstrPositiveLargeSConstraint(IntDomainVar[] vs, LargeRelation relation, IEnvironment environment) {
        super(vs, relation);
        this.arity = vs.length;
        this.relation = (TuplesList)relation;
        this.futureVars = new LinkedList<Integer>();
        this.gacValues = new BitSet[this.arity];
        this.nbGacValues = new int[this.arity];
        this.offsets = new int[this.arity];
        for (int i = 0; i < this.arity; ++i) {
            this.offsets[i] = vs[i].getInf();
            this.gacValues[i] = new BitSet(vs[i].getSup() - vs[i].getInf() + 1);
        }
        int[] listuples = new int[this.relation.getTupleTable().length];
        for (int i = 0; i < listuples.length; ++i) {
            listuples[i] = i;
        }
        this.ltuples = environment.makeBipartiteIntList(listuples);
        int[][] tt = this.relation.getTupleTable();
        boolean fastValidCheckAllowed = true;
        boolean fastBooleanValidCheckAllowed = true;
        for (int i = 0; i < tt.length; ++i) {
            for (int j = 0; j < tt[i].length; ++j) {
                int lb = vs[j].getInf();
                int ub = vs[j].getSup();
                if (lb > tt[i][j] || ub < tt[i][j]) {
                    fastValidCheckAllowed = false;
                }
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
            }
            if (!fastBooleanValidCheckAllowed && !fastValidCheckAllowed) break;
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, (IntDomainVar[])this.vars) : (fastValidCheckAllowed ? new FastValidityChecker(this.arity, (IntDomainVar[])this.vars) : new ValidityChecker(this.arity, (IntDomainVar[])this.vars));
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public void initializeData() {
        this.futureVars.clear();
        for (int i = 0; i < this.arity; ++i) {
            this.gacValues[i].clear();
            this.nbGacValues[i] = 0;
            this.futureVars.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruningPhase() throws ContradictionException {
        for (int vIdx : this.futureVars) {
            int left;
            IntDomainVar v = ((IntDomainVar[])this.vars)[vIdx];
            DisposableIntIterator it3 = v.getDomain().getIterator();
            int right = left = Integer.MIN_VALUE;
            try {
                while (it3.hasNext()) {
                    int val = it3.next();
                    if (this.gacValues[vIdx].get(val - this.offsets[vIdx])) continue;
                    if (val == right + 1) {
                        right = val;
                        continue;
                    }
                    v.removeInterval(left, right, this, false);
                    left = right = val;
                }
                v.removeInterval(left, right, this, false);
            }
            finally {
                it3.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainList(int idx) {
        DisposableIntIterator it = this.ltuples.getIterator();
        while (it.hasNext()) {
            int idxt = it.next();
            int[] tuple = this.relation.getTuple(idxt);
            try {
                if (this.valcheck.isValid(tuple, idx)) {
                    Iterator<Integer> itf = this.futureVars.iterator();
                    while (itf.hasNext()) {
                        int vIdx = itf.next();
                        if (this.gacValues[vIdx].get(tuple[vIdx] - this.offsets[vIdx])) continue;
                        this.gacValues[vIdx].set(tuple[vIdx] - this.offsets[vIdx]);
                        int n = vIdx;
                        this.nbGacValues[n] = this.nbGacValues[n] + 1;
                        if (this.nbGacValues[vIdx] != ((IntDomainVar[])this.vars)[vIdx].getDomainSize()) continue;
                        itf.remove();
                    }
                    continue;
                }
                it.remove();
            }
            finally {
                it.dispose();
            }
        }
    }

    public void maintainList() {
        DisposableIntIterator it = this.ltuples.getIterator();
        while (it.hasNext()) {
            int idxt = it.next();
            int[] tuple = this.relation.getTuple(idxt);
            if (this.valcheck.isValid(tuple)) {
                Iterator<Integer> itf = this.futureVars.iterator();
                while (itf.hasNext()) {
                    int vIdx = itf.next();
                    if (this.gacValues[vIdx].get(tuple[vIdx] - this.offsets[vIdx])) continue;
                    this.gacValues[vIdx].set(tuple[vIdx] - this.offsets[vIdx]);
                    int n = vIdx;
                    this.nbGacValues[n] = this.nbGacValues[n] + 1;
                    if (this.nbGacValues[vIdx] != ((IntDomainVar[])this.vars)[vIdx].getDomainSize()) continue;
                    itf.remove();
                }
                continue;
            }
            it.remove();
        }
        it.dispose();
    }

    public void gacstr(int idx) throws ContradictionException {
        this.initializeData();
        this.maintainList(idx);
        this.pruningPhase();
    }

    public void gacstr() throws ContradictionException {
        this.initializeData();
        this.maintainList();
        this.pruningPhase();
        if (this.getCartesianProduct() <= (double)this.ltuples.size()) {
            this.setEntailed();
        }
    }

    public double getCartesianProduct() {
        double cp = 1.0;
        for (int i = 0; i < this.arity; ++i) {
            cp *= (double)((IntDomainVar[])this.vars)[i].getDomainSize();
        }
        return cp;
    }

    @Override
    public void propagate() throws ContradictionException {
        this.valcheck.sortvars();
        this.gacstr();
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter(varIndex);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    public void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        this.gacstr();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int[][] tupleList = this.relation.getTupleTable();
        for (int i = 0; i < tupleList.length; ++i) {
            boolean isValid = true;
            for (int j = 0; isValid && j < tuple.length; ++j) {
                if (tuple[j] == tupleList[i][j]) continue;
                isValid = false;
            }
            if (!isValid) continue;
            return true;
        }
        return false;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("GACStrAllowedLarge({");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

