/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.comparator;

import choco.kernel.common.util.comparator.IPermutation;
import choco.kernel.common.util.comparator.Identity;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractSortingPermutation
implements IPermutation,
Comparator<Integer> {
    public static final IPermutation IDENTITY = Identity.SINGLETON;
    protected boolean identity;
    protected final Integer[] orderingPermutation;
    protected final Integer[] reversePermutation;

    public AbstractSortingPermutation(int size) {
        this.orderingPermutation = new Integer[size];
        this.reversePermutation = new Integer[size];
        for (int i = 0; i < this.orderingPermutation.length; ++i) {
            this.orderingPermutation[i] = i;
        }
    }

    public final void sort(boolean reverse) {
        Arrays.sort(this.orderingPermutation, reverse ? Collections.reverseOrder(this) : this);
        this.identity = true;
        for (int i = 0; i < this.orderingPermutation.length; ++i) {
            this.reversePermutation[this.orderingPermutation[i].intValue()] = i;
            if (!this.identity || i == this.orderingPermutation[i]) continue;
            this.identity = false;
        }
    }

    @Override
    public final <T> void applyPermutation(T[] source, T[] dest) {
        if (source.length != this.orderingPermutation.length || source.length != dest.length) {
            throw new ArrayIndexOutOfBoundsException("the two arguments should have the same length than the permutation array");
        }
        for (int i = 0; i < source.length; ++i) {
            dest[i] = source[this.orderingPermutation[i]];
        }
    }

    @Override
    public <T> void applyPermutation(List<T> source, T[] dest) {
        if (source.size() != this.orderingPermutation.length || source.size() != dest.length) {
            throw new ArrayIndexOutOfBoundsException("the two arguments should have the same length than the permutation array");
        }
        int k = 0;
        for (T s : source) {
            dest[k++] = s;
        }
    }

    @Override
    public int[] applyPermutation(int[] source) {
        int[] dest = new int[this.orderingPermutation.length];
        for (int i = 0; i < this.orderingPermutation.length; ++i) {
            dest[i] = source[this.orderingPermutation[i]];
        }
        return dest;
    }

    @Override
    public final int getOriginalIndex(int idx) {
        return this.orderingPermutation[idx];
    }

    @Override
    public final int getPermutationIndex(int idx) {
        return this.reversePermutation[idx];
    }

    @Override
    public final boolean isIdentity() {
        return this.identity;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Ordering permutation: ");
        b.append(Arrays.toString((Object[])this.orderingPermutation));
        return new String(b);
    }
}

