% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix.R
\name{print.MarkovMix}
\alias{print.MarkovMix}
\title{Print MarkovMix object}
\usage{
\method{print}{MarkovMix}(x, sep = "->", print_max = 20L, print_min = 10L, ...)
}
\arguments{
\item{x}{\code{\link{MarkovMix}} object.}

\item{sep}{Character (1L) used as separator between states in the row names of transition matrix.}

\item{print_max, print_min}{Integers as the numbers of rows to print each transition matrix.
See \code{\link[pillar]{pillar_options}} for details.}

\item{...}{Currently ignored for this method.}
}
\value{
Input \code{x}, invisibly.
}
\description{
\code{print.MarkovMix} prints \code{\link{MarkovMix}} object in a user-friendly form,
including component priors and transition matrices.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
# Generate a list of integer sequences of different lengths with 4 states
test_states <- seq_len(4L)
test_maxlen <- 10L
set.seed(1111L)
test_seq <- purrr::map(
  seq_len(100L),
  ~ sample(test_states, sample.int(test_maxlen, 1L), replace = TRUE)
)

# Fit a 1-order Markov chain
markov_fit <- fit_markov_mix(
  seq_list = test_seq,
  order. = 1L,
  states = test_states
)
print(markov_fit)

# Fit a mixture of 2-order Markov chain with 3 components
test_n_comp <- 3L
test_clusters <- matrix(
  runif(length(test_seq) * test_n_comp),
  nrow = length(test_seq),
  ncol = test_n_comp
)
markov_mix_fit <- fit_markov_mix(
  seq_list = test_seq,
  order. = 2L,
  states = test_states,
  clusters = test_clusters
)
print(markov_mix_fit)
}
\seealso{
Other MarkovMix methods: 
\code{\link{predict.MarkovMix}()}
}
\author{
Xiurui Zhu
}
\concept{MarkovMix methods}
