% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classesAndMethods.R
\docType{methods}
\name{transitionProbability}
\alias{transitionProbability}
\alias{transitionProbability,markovchain-method}
\title{Function to get the transition probabilities from initial 
       to subsequent states.}
\usage{
transitionProbability(object, t0, t1)

\S4method{transitionProbability}{markovchain}(object, t0, t1)
}
\arguments{
\item{object}{A \code{markovchain} object.}

\item{t0}{Initial state.}

\item{t1}{Subsequent state.}
}
\value{
Numeric Vector
}
\description{
This is a convenience function to get transition probabilities.
}
\examples{
statesNames <- c("a", "b", "c")
markovB <- new("markovchain", states = statesNames, transitionMatrix =
                matrix(c(0.2, 0.5, 0.3, 0, 1, 0, 0.1, 0.8, 0.1), nrow = 3,
                byrow = TRUE, dimnames=list(statesNames,statesNames)),
               name = "A markovchain Object" 
)    
transitionProbability(markovB,"b", "c")
}
\references{
A First Course in Probability (8th Edition), 
            Sheldon Ross, Prentice Hall 2010
}
\seealso{
\code{\linkS4class{markovchain}}
}
\author{
Giorgio Spedicato
}
