% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_statisticalTests.R
\name{verifyMarkovProperty}
\alias{assessOrder}
\alias{assessStationarity}
\alias{divergenceTest}
\alias{verifyMarkovProperty}
\title{Various functions to perform statistical inference of DTMC}
\usage{
verifyMarkovProperty(sequence, ...)

assessOrder(sequence)

assessStationarity(sequence, nblocks)

divergenceTest(sequence, hypothetic)
}
\arguments{
\item{sequence}{An empirical sequence.}

\item{...}{Parameters for chi-square test.}

\item{nblocks}{Number of blocks.}

\item{hypothetic}{A transition matrix for a hypothetic markov chain sequence.}
}
\value{
Verification result
}
\description{
These functions verify the Markov property, assess 
             the order and stationarity of the Markov chain.
}
\examples{
sequence <- c("a", "b", "a", "a", "a", "a", "b", "a", "b",
              "a", "b", "a", "a", "b", "b", "b", "a")
mcFit <- markovchainFit(data = sequence, byrow = FALSE)
verifyMarkovProperty(sequence)
assessOrder(sequence)
assessStationarity(sequence, 1)
divergenceTest(sequence, mcFit$estimate@transitionMatrix)

}
\author{
Tae Seung Kang, Giorgio Alfredo Spedicato
}
\references{
Monika, Anderson and Goodman.
}
\seealso{
\code{markovchain}
}

