% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_classesAndMethods.R
\docType{methods}
\name{steadyStates}
\alias{steadyStates}
\alias{steadyStates,markovchain-method}
\title{Stationary states of a \code{markovchain} objeect}
\usage{
steadyStates(object)

\S4method{steadyStates}{markovchain}(object)
}
\arguments{
\item{object}{A discrete \code{markovchain} object}
}
\value{
A matrix corresponding to the stationary states
}
\description{
This method returns the stationary vector in matricial form of a markovchain object.
}
\note{
The steady states are identified starting from which eigenvectors correspond 
      to identity eigenvalues and then normalizing them to sum up to unity. When negative values are found 
      in the matrix, the eigenvalues extraction is performed on the recurrent classes submatrix.
}
\examples{
statesNames <- c("a", "b", "c")
markovB <- new("markovchain", states = statesNames, transitionMatrix =
                matrix(c(0.2, 0.5, 0.3, 0, 1, 0, 0.1, 0.8, 0.1), nrow = 3,
                byrow = TRUE, dimnames=list(statesNames,statesNames)),
               name = "A markovchain Object" 
)       
steadyStates(markovB)

}
\author{
Giorgio Spedicato
}
\references{
A First Course in Probability (8th Edition), Sheldon Ross, Prentice Hall 2010
}
\seealso{
\code{\linkS4class{markovchain}}
}

