% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_probabilistic.R
\name{firstPassage}
\alias{firstPassage}
\title{First passage across states}
\usage{
firstPassage(object, state, n)
}
\arguments{
\item{object}{A \code{markovchain} object}

\item{state}{Initial state}

\item{n}{Number of rows on which compute the distribution}
}
\value{
A matrix of size 1:n x number of states showing the probability of the 
        first time of passage in states to be exactly the number in the row.
}
\description{
This function compute the first passage probability in states
}
\details{
Based on Feres' Matlab listings
}
\examples{
simpleMc <- new("markovchain", states = c("a", "b"),
                 transitionMatrix = matrix(c(0.4, 0.6, .3, .7), 
                                    nrow = 2, byrow = TRUE))
firstPassage(simpleMc, "b", 20)

}
\author{
Giorgio Spedicato
}
\references{
Renaldo Feres, Notes for Math 450 Matlab listings for Markov chains
}
\seealso{
\code{\link{conditionalDistribution}}
}

