% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_my_file.R
\name{mark_my_file}
\alias{mark_my_file}
\title{Mark assignment file}
\usage{
mark_my_file(tasks = NULL, mark_file = file.choose(), lab_file,
  force_get_tests = FALSE, quiet = FALSE, reporter)
}
\arguments{
\item{tasks}{Which task should be corrected (if more than one). Default is all. 
To see the different task, see \code{\link{show_tasks}}.}

\item{mark_file}{Path to the file to mark.}

\item{lab_file}{Assignment file to set before marking the assignment (url or local path).}

\item{force_get_tests}{Force download of test files before marking of assignments. Default is FALSE.}

\item{quiet}{Should test be run without output?}

\item{reporter}{to use. Default is the 'summary' or specified in assignment yml file.}
}
\description{
Mark a specific assignment file
}
\examples{
assignment_path <- 
  paste0(system.file(package = "markmyassignment"), "/extdata/example_assignment01.yml")
file_path <- paste0(system.file(package = "markmyassignment"), "/extdata/example_lab_file.R")
mark_my_file(mark_file = file_path, lab_file = assignment_path)

}

