% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMMutilities.r
\name{backward_prob}
\alias{backward_prob}
\title{Computes backward probabilities}
\usage{
backward_prob(object, ddl = NULL)
}
\arguments{
\item{object}{fitted crm model (must be an HMM model)}

\item{ddl}{design data list}
}
\value{
array of backward probabilities (one for each id, state, occasion)
}
\description{
Computes backward probability sequence for a set of capture histories
}
\examples{
#
\donttest{
# This example is excluded from testing to reduce package check time
# cormack-jolly-seber model
data(dipper)
mod=crm(dipper,model="hmmcjs")
backward_prob(mod)
}
}
\references{
Zucchini, W. and I.L. MacDonald. 2009. Hidden Markov Models for Time Series: An Introduction using R. Chapman and Hall, Boca Raton, FL. See page 61.
}
\author{
Jeff Laake
}
\keyword{utility}
