% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannon}
\alias{shannon}
\title{Calculates Shannon's Index of Diversity}
\usage{
shannon(X, groups, species.table = NULL, metric = "ABUNDANCE", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{ABUNDANCE}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{ABUNDANCE} is the corresponding abundance
(stratified and corrected for catchability as required).}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate the indicator. Default is \code{metric = "ABUNDANCE"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
 column \code{ShannonDiversity_group} for each entry in \code{groups}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 values is assigned NA.
}
\description{
This function calculates Shannon's Index of Diversity for \eqn{j}
 areas and \eqn{i} years.
}
\details{
Shannon's index of diversity (H'): \deqn{H' = -\Sigma p_i ln(p_i)}
 \eqn{p_i} is the proportion of the total sample contributed by the i(th)
 species and \eqn{S} is the number of species recorded in the sample. This
 index is sensitive to the number of species recorded in the sample
 (Magurran, 1988).
}
\examples{
data(X)
shannon(X, groups = c("ALL", "FINFISH"), metric = "ABUNDANCE", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Greenstreet SP, Rogers SI. 2006. Indicators of the health of the North Sea
 fish community: identifying reference levels for an ecosystem approach to
 management. ICES J Mar Sci J du Cons 63:573-593

 Magurran, AE. 1988. Ecological Diversity and its Measurement. Chapman and
 Hall, London. 179 pp.
}
\seealso{
Other biodiversity indicators: \code{\link{allBiodiversity}},
  \code{\link{heips}}, \code{\link{hillN1}},
  \code{\link{hillN2}}, \code{\link{kemptonQ}},
  \code{\link{margalef}}, \code{\link{pielouEvenness}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{biodiversity indicators}
