% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allPressure.R
\name{allPressure}
\alias{allPressure}
\title{Calculates all Pressure indicators}
\usage{
allPressure(X, land, species.table, speciesinfo.table, landings.groups,
  FP.groups, minTL = c(0, 3.25), years, raw = TRUE, std = TRUE,
  glob.env = TRUE, export.path = NULL, export.id = NULL)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{BIOMASS}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{BIOMASS} is the corresponding biomass (stratified
and corrected for catchability as required).}

\item{land}{A dataframe of commercial landings data with columns \code{YEAR},
\code{ID}, \code{SPECIES} and \code{CATCH}. \code{YEAR} indicates the year
the landing was recorded, \code{ID} is an area code indicating where the
landing was recorded, \code{SPECIES} is a numeric code indicating the
species landed, and \code{CATCH} is the corresponding landed weight (in the
same  units as \code{BIOMASS} in \code{X}).}

\item{species.table}{A table where the column names match the entries in
\code{landings.groups}. Column entries are the species codes indicating the
species from \code{land} included in each group. \code{species.table} may
also include columns for other species groups; these will be ignored.}

\item{speciesinfo.table}{A table with columns \code{SPECIES} and the
corresponding \code{TL_LAND} (trophic level of landed species). Entries in
the \code{SPECIES} column should be the unique values of species codes in
land (or a subset thereof). Other columns will be ignored.}

\item{landings.groups}{A vector indicating the species groups for which to
calculate the landings. Each entry must be a character string matching the
name of a column in \code{species.table}. If \code{landings.groups = NULL},
no Landings indicators will be calculated.}

\item{FP.groups}{A dataframe with two columns, which must be named
\code{group.land} and \code{group.X}. Each row holds the group names to
calculate the fishing pressure on a target group, with the numerator in
column \code{group.land} and the denominator in column \code{group.X}. Each
entry must be a character string matching the name of a column in
\code{species.table}. If \code{FP.groups = NULL}, no fishing pressure
indicators will be calculated.}

\item{minTL}{A vector containing minimum trophic level to include when
calculating the mean trophic level of the landings. Default is \code{minTL =
c(0, 3.25)}, which will return the mean trophic level of the landings and
the marine trophic index.}

\item{years}{A vector of years for which to calculate indicators.}

\item{raw}{A logical value. If \code{raw = TRUE}, the raw indicator values are
returned by the function. If \code{raw = FALSE}, the raw indicator values are
not returned. Default is \code{raw = TRUE}. Either \code{raw} or \code{std}
must be \code{TRUE}.}

\item{std}{A logical value. If \code{std = TRUE}, the standardized indicator
values for each area \code{ID} are returned by the function. Indicators are
standardized using z-scores, i.e., by subtracting the mean and dividing by
the standard deviation (ignoring \code{NA} values). If \code{std = FALSE},
the standardized indicator values are not returned. Default is \code{std =
TRUE}. Either \code{raw} or \code{std} must be \code{TRUE}.}

\item{glob.env}{Logical value indicating whether to return output to global
environment. Default is \code{glob.env = TRUE}.}

\item{export.path}{File path indicating where to save a .csv file of
calculated indicators (named pressure_export.id.csv; see below). If
\code{export.file = NULL}, the indicator dataframe will not be exported as a
.csv file. Default is \code{export.path = NULL}.}

\item{export.id}{Character string to modify the name of the .csv file (if
export.path is specified), for example an area name or date of analysis. The
exported .csv file is named pressure_export.id.csv. Default is
\code{export.id = NULL}.}
}
\value{
Returns a dataframe with columns \code{ID}, \code{YEAR}, and
 indicators corresponding to the arguments supplied to the function.
 Standardized indicators are noted with \code{_s} in the name.
}
\description{
This function calculates all (or a subset) of the Pressure
 indicators for \eqn{j} areas and \eqn{i} years. The user can choose whether
 the function returns the indicator dataframe to the global environment,
 exports the dataframe to a .csv file, or both. The user can also choose
 whether the function returns the raw indicator values, the standardized
 (z-score) values, or both.
}
\details{
This function calculates the Pressure indicators: Diversity of the
 Target Species, Total Landings, Landings of Target Groups, Fishing Pressure
 on the Community, Fishing Pressure on Target Groups, Mean Trophic Level of
 the Landings, and the Marine Trophic Index. If data are not available to
 calculate one or more of these indicators, a subset will be returned. See
 the help file for the individual functions for information on how each
 indicator is calculated.
}
\examples{
# Compile data
data(X)
data(land)
data(species.table)
data(species.info)

# Species groups of interest
landings.groups <- c("ALL", "CLUPEIDS.L", "FLATFISH.L", "GROUNDFISH.L")
FP.groups <- data.frame(rbind(c("ALL", "ALL"),
   c("CLUPEIDS", "CLUPEIDS.L"),
   c("FLATFISH", "FLATFISH.L"),
   c("GROUNDFISH", "GROUNDFISH.L")))
names(FP.groups) <- c("group.X", "group.land")

# Calculate standardized indicators
allPressure(X = X, land = land, species.table = species.table,
   speciesinfo.table = species.info, landings.groups = landings.groups,
   FP.groups = FP.groups, minTL = c(0, 3.25), years = c(2014:2019), raw = FALSE, std = TRUE)
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.
}
\seealso{
Other fishing pressure indicators: \code{\link{fishingPressure}},
  \code{\link{landings}}, \code{\link{meanTLLandings}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{fishing pressure indicators}
