% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cme.R
\name{plot_cme}
\alias{plot_cme}
\title{Conditional marginal effects plot}
\usage{
plot_cme(
  model,
  effect,
  condition,
  type = "response",
  conf.int = TRUE,
  conf.level = 0.95,
  draw = TRUE
)
}
\arguments{
\item{model}{Model object}

\item{effect}{Name of the variable whose marginal effect we want to plot on the y-axis}

\item{condition}{String or vector of two strings. The first is a variable
name to be displayed on the x-axis. The second is a variable whose values
will be displayed in different colors.}

\item{type}{Type(s) of prediction as string or vector This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}

\item{conf.int}{Logical indicating whether or not to include a confidence interval.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int=TRUE}. Must be strictly greater than 0 and less than 1. Defaults
to 0.95, which corresponds to a 95 percent confidence interval.}

\item{draw}{\code{TRUE} returns a \code{ggplot2} plot. \code{FALSE} returns a \code{data.frame} of the underlying data.}
}
\value{
A \code{ggplot2} object
}
\description{
In models where two continuous variables are interacted, the marginal effect
of one variable is conditional on the value of the other variable. This
function draws a plot of the marginal effect of the \code{effect} variable for
different values of the \code{condition} variable.
}
\examples{
mod <- lm(mpg ~ hp * wt, data = mtcars)
plot_cme(mod, effect = "hp", condition = "wt")

mod <- lm(mpg ~ hp * wt * am, data = mtcars)
plot_cme(mod, effect = "hp", condition = c("wt", "am"))

}
