% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winOddsPlots.R
\name{cumulative_plot.maraca}
\alias{cumulative_plot.maraca}
\title{Generic function to create a plot showing the components used in
calculating win odds (wins and ties) cumulated for all
outcomes directly from a maraca object.
Note that for this plot, when creating the maraca object using the maraca()
function, the argument "compute_win_odds" has to be set to TRUE.
Check the vignette "Maraca Plots - Plotting win odds" for more details.}
\usage{
\method{cumulative_plot}{maraca}(
  x,
  theme = "maraca",
  include = c("win odds", "win ratio"),
  reverse = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of S3 class 'maraca'.}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "color1", "color2" and none".
For more details, check the vignette called
"Maraca Plots - Plotting win odds".}

\item{include}{Vector or single string indicating which statistics to
include in the right hand side plot. Acceptable values are
"win odds" and/or "win ratio". Default is c("win odds", "win ratio").}

\item{reverse}{Flag indicating if the cumulated outcomes should be
displayed in order from top to bottom (FALSE, the default)
or in reverse (TRUE).}

\item{\dots}{not used}
}
\value{
Cumulative plot as a patchwork list. Individual plots can
        be accessed like list items (plot[[1]] and plot[[2]]).
}
\description{
Generic function to create a plot showing the components used in
calculating win odds (wins and ties) cumulated for all
outcomes directly from a maraca object.
Note that for this plot, when creating the maraca object using the maraca()
function, the argument "compute_win_odds" has to be set to TRUE.
Check the vignette "Maraca Plots - Plotting win odds" for more details.
}
\examples{

data(hce_scenario_a)

maraca_dat <- maraca(data = hce_scenario_a,
                     step_outcomes = c("Outcome I", "Outcome II",
                                      "Outcome III", "Outcome IV"),
                     last_outcome = "Continuous outcome",
                     fixed_followup_days = 3 * 365,
                     column_names = c(outcome = "GROUP",
                                      arm = "TRTP",
                                      value = "AVAL0"),
                     arm_levels = c(active = "Active",
                                    control = "Control"),
                     compute_win_odds = TRUE
                     )

cumulative_plot(maraca_dat)

}
