% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slideView.R
\docType{methods}
\name{slideView}
\alias{slideView}
\alias{slideView,RasterStackBrick,RasterStackBrick-method}
\alias{slideView,RasterLayer,RasterLayer-method}
\alias{slideView,RasterStackBrick,RasterLayer-method}
\alias{slideView,RasterLayer,RasterStackBrick-method}
\alias{slideView,character,character-method}
\alias{slideview,ANY-method}
\alias{slideview}
\title{slideView}
\usage{
\S4method{slideView}{RasterStackBrick,RasterStackBrick}(img1, img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())), r = 3, g = 2,
  b = 1, na.color = mapviewGetOption("na.color"),
  maxpixels = mapviewGetOption("plainview.maxpixels"), ...)

\S4method{slideView}{RasterLayer,RasterLayer}(img1, img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())), legend = TRUE,
  col.regions = mapviewGetOption("raster.palette")(256),
  na.color = mapviewGetOption("na.color"),
  maxpixels = mapviewGetOption("plainview.maxpixels"))

\S4method{slideView}{RasterStackBrick,RasterLayer}(img1, img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())), legend = TRUE,
  r = 3, g = 2, b = 1,
  col.regions = mapviewGetOption("raster.palette")(256),
  na.color = mapviewGetOption("na.color"),
  maxpixels = mapviewGetOption("plainview.maxpixels"), ...)

\S4method{slideView}{RasterLayer,RasterStackBrick}(img1, img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())), legend = TRUE,
  r = 3, g = 2, b = 1,
  col.regions = mapviewGetOption("raster.palette")(256),
  na.color = mapviewGetOption("na.color"),
  maxpixels = mapviewGetOption("plainview.maxpixels"), ...)

\S4method{slideView}{character,character}(img1, img2,
  label1 = deparse(substitute(img1, env = parent.frame())),
  label2 = deparse(substitute(img2, env = parent.frame())))

\S4method{slideview}{ANY}(...)
}
\arguments{
\item{img1}{a RasterStack/Brick, RasterLayer or path to a .png file}

\item{img2}{a RasterStack/Brick, RasterLayer or path to a .png file}

\item{label1}{slider label for img1 (defaults to object name)}

\item{label2}{slider label for img2 (defaults to object name)}

\item{r}{integer. Index of the Red channel, between 1 and nlayers(x)}

\item{g}{integer. Index of the Green channel, between 1 and nlayers(x)}

\item{b}{integer. Index of the Blue channel, between 1 and nlayers(x)}

\item{na.color}{the color to be used for NA pixels}

\item{maxpixels}{integer > 0. Maximum number of cells to use for the plot.
If maxpixels < \code{ncell(x)}, sampleRegular is used before plotting.}

\item{...}{additional arguments passed on to repective functions.}

\item{legend}{whether to plot legends for the two images (ignored for
RatserStacks/*Bricks).}

\item{col.regions}{color (palette).See \code{\link{levelplot}} for details.}

\item{color}{the color palette to be used for visualising RasterLayers}
}
\description{
Two images are overlaid and a slider is provided to interactively
compare the two images in a before-after like fashion. \code{img1} and
\code{img2} can either be two RasterLayers, two RasterBricks/Stacks or
two character strings. In the latter case it is assumed that these
point to .png images on the disk.

NOTE: In case you want to include multiple slideviews in one page in a
Rmd or flexdashboard we highly recommend using package widgetframe.
Also, make sure to use different image names and/or labels
for each of the RasterLayers/Bricks/Stacks.
Otherwise things will likely not work properly.

This is a modified implementation of http://bl.ocks.org/rfriberg/8327361
}
\details{
Compare two images trough interactive swiping overlay


For slideView there are a few keyboard shortcuts defined:
\itemize{
  \item space - toggle antialiasing
  \item esc - zoom to layer extent
  \item enter - set zoom to 1
  \item ctrl - increase panning speed by 10
}
}
\section{Methods (by class)}{
\itemize{
\item \code{img1 = RasterLayer,img2 = RasterLayer}: for RasterLayers

\item \code{img1 = RasterStackBrick,img2 = RasterLayer}: for RasterStackBrick, RasterLayer

\item \code{img1 = RasterLayer,img2 = RasterStackBrick}: for RasterLayer, RasterStackBrick

\item \code{img1 = character,img2 = character}: for png files

\item \code{ANY}: alias for ease of typing
}}

\examples{
### raster data ###
library(sp)
library(raster)

data(poppendorf)

stck1 <- subset(poppendorf, c(3, 4, 5))
stck2 <- subset(poppendorf, c(2, 3, 4))
slideView(stck1, stck2)

\dontrun{
### example taken from
### http://www.news.com.au/technology/environment/nasa-images-reveal-
### aral-sea-is-shrinking-before-our-eyes/story-e6frflp0-1227074133835

library(jpeg)
library(raster)

web_img2000 <- "http://cdn.newsapi.com.au/image/v1/68565a36c0fccb1bc43c09d96e8fb029"

jpg2000 <- readJPEG(readBin(web_img2000, "raw", 1e6))

# Convert imagedata to raster
rst_blue2000 <- raster(jpg2000[, , 1])
rst_green2000 <- raster(jpg2000[, , 2])
rst_red2000 <- raster(jpg2000[, , 3])

img2000 <- brick(rst_red2000, rst_green2000, rst_blue2000)

web_img2013 <- "http://cdn.newsapi.com.au/image/v1/5707499d769db4b8ec76e8df61933f2a"

jpg2013 <- readJPEG(readBin(web_img2013, "raw", 1e6))

# Convert imagedata to raster
rst_blue2013 <- raster(jpg2013[, , 1])
rst_green2013 <- raster(jpg2013[, , 2])
rst_red2013 <- raster(jpg2013[, , 3])

img2013 <- brick(rst_red2013, rst_green2013, rst_blue2013)

slideView(img2000, img2013, label1 = "before", label2 = "after")
}

}
\author{
Tim Appelhans

Stephan Woellauer
}
