% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFeatures.R
\name{addFeatures}
\alias{addFeatures}
\title{Type agnositc version of \code{leaflet::add*} functions.}
\usage{
addFeatures(map, data, ...)
}
\arguments{
\item{map}{A \code{leaflet} or \code{mapview} map.}

\item{data}{A \code{sf} object to be added to the \code{map}.}

\item{...}{Further arguments passed to the respective \code{leaflet::add*}
functions. See \code{\link{addCircleMarkers}}, \code{\link{addPolylines}}
and \code{\link{addPolygons}}.}
}
\value{
A leaflet \code{map} object.
}
\description{
Add simple features geomertries from \code{\link[sf]{sf}}
}
\examples{
\dontrun{
leaflet() \%>\% addTiles() \%>\% addCircleMarkers(data = breweries)
leaflet() \%>\% addTiles() \%>\% addFeatures(data = breweries)

leaflet() \%>\% addTiles() \%>\% addPolylines(data = atlStorms2005)
leaflet() \%>\% addTiles() \%>\% addFeatures(atlStorms2005)

leaflet() \%>\% addTiles() \%>\% addPolygons(data = franconia)
leaflet() \%>\% addTiles() \%>\% addFeatures(franconia)
}

}
