% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapView.R
\docType{methods}
\name{mapView}
\alias{mapView}
\alias{mapView,RasterLayer-method}
\alias{mapView,RasterStackBrick-method}
\alias{mapView,Satellite-method}
\alias{mapView,SpatialLines-method}
\alias{mapView,SpatialLinesDataFrame-method}
\alias{mapView,SpatialPixelsDataFrame-method}
\alias{mapView,SpatialPoints-method}
\alias{mapView,SpatialPointsDataFrame-method}
\alias{mapView,SpatialPolygons-method}
\alias{mapView,SpatialPolygonsDataFrame-method}
\alias{mapView,missing-method}
\alias{mapview}
\alias{mapview,ANY-method}
\title{View spatial objects interactively}
\usage{
\S4method{mapView}{RasterLayer}(x, map = NULL,
  maxpixels = mapviewGetOption("maxpixels"),
  col.regions = mapviewGetOption("raster.palette")(256), at,
  na.color = mapviewGetOption("na.color"), use.layer.names = FALSE,
  values = NULL, map.types = mapviewGetOption("basemaps"),
  alpha.regions = 0.8, legend = TRUE, legend.opacity = 1, trim = TRUE,
  verbose = mapviewGetOption("verbose"), layer.name = deparse(substitute(x,
  env = parent.frame())), ...)

\S4method{mapView}{RasterStackBrick}(x, map = NULL,
  maxpixels = mapviewGetOption("maxpixels"),
  col.regions = mapviewGetOption("raster.palette")(256), at,
  na.color = mapviewGetOption("na.color"), values = NULL,
  map.types = mapviewGetOption("basemaps"), legend = FALSE,
  legend.opacity = 1, trim = TRUE, verbose = mapviewGetOption("verbose"),
  ...)

\S4method{mapView}{Satellite}(x, ...)

\S4method{mapView}{SpatialPixelsDataFrame}(x, zcol = NULL, ...)

\S4method{mapView}{SpatialPointsDataFrame}(x, zcol = NULL, map = NULL,
  burst = FALSE, color = mapviewGetOption("vector.palette")(256),
  na.color = mapviewGetOption("na.color"), cex = 10, lwd = 2,
  alpha = 0.6, alpha.regions = 0.2,
  map.types = mapviewGetOption("basemaps"), legend = FALSE,
  legend.opacity = 1, verbose = mapviewGetOption("verbose"),
  layer.name = deparse(substitute(x, env = parent.frame())), popup = NULL,
  ...)

\S4method{mapView}{SpatialPoints}(x, map = NULL, zcol = NULL,
  color = "#460000", na.color = mapviewGetOption("na.color"), cex = 10,
  lwd = 2, alpha = 0.6, alpha.regions = 0.2,
  map.types = mapviewGetOption("basemaps"),
  verbose = mapviewGetOption("verbose"), layer.name = deparse(substitute(x,
  env = parent.frame())), ...)

\S4method{mapView}{SpatialPolygonsDataFrame}(x, zcol = NULL, map = NULL,
  burst = FALSE, color = mapviewGetOption("vector.palette")(256),
  na.color = mapviewGetOption("na.color"), lwd = 2, alpha = 0.8,
  alpha.regions = 0.2, values = NULL,
  map.types = mapviewGetOption("basemaps"), legend = FALSE,
  legend.opacity = 1, verbose = mapviewGetOption("verbose"),
  layer.name = deparse(substitute(x, env = parent.frame())), popup = NULL,
  ...)

\S4method{mapView}{SpatialPolygons}(x, map = NULL, color = "#460000",
  na.color = mapviewGetOption("na.color"),
  map.types = mapviewGetOption("basemaps"), lwd = 2, alpha.regions = 0.8,
  verbose = mapviewGetOption("verbose"), layer.name = deparse(substitute(x,
  env = parent.frame())), ...)

\S4method{mapView}{SpatialLinesDataFrame}(x, zcol = NULL, map = NULL,
  burst = FALSE, color = mapviewGetOption("vector.palette")(256),
  na.color = mapviewGetOption("na.color"), lwd = 2, alpha = 0.8,
  values = NULL, map.types = mapviewGetOption("basemaps"), legend = FALSE,
  legend.opacity = 1, verbose = mapviewGetOption("verbose"),
  layer.name = deparse(substitute(x, env = parent.frame())), popup = NULL,
  ...)

\S4method{mapView}{SpatialLines}(x, map = NULL, zcol = NULL,
  color = "#460000", na.color = mapviewGetOption("na.color"), lwd = 2,
  alpha = 0.8, map.types = mapviewGetOption("basemaps"),
  verbose = mapviewGetOption("verbose"), layer.name = deparse(substitute(x,
  env = parent.frame())), ...)

\S4method{mapView}{missing}(map.types = mapviewGetOption("basemaps"),
  easter.egg = FALSE)

\S4method{mapview}{ANY}(...)
}
\arguments{
\item{x}{a \code{\link{raster}}* object}

\item{map}{an optional existing map to be updated/added to}

\item{maxpixels}{integer > 0. Maximum number of cells to use for the plot.
If maxpixels < \code{ncell(x)}, sampleRegular is used before plotting.}

\item{col.regions}{color (palette) pixels.
See \code{\link{levelplot}} for details.}

\item{at}{the breakpoints used for the visualisation.
See \code{\link{levelplot}} for details.}

\item{na.color}{color for missing values}

\item{use.layer.names}{should layer names of the Raster* object be used?}

\item{values}{a vector of values for the visualisation of the layers.
Per default these are calculated based on the supplied raster* object.}

\item{map.types}{character spcifications for the base maps.
see \url{http://leaflet-extras.github.io/leaflet-providers/preview/}
for available options.}

\item{alpha.regions}{opacity of the fills or the raster layer(s)}

\item{legend}{should a legend be plotted}

\item{legend.opacity}{opacity of the legend}

\item{trim}{should the raster be trimmed in case there are NAs on the egdes}

\item{verbose}{should some details be printed during the process}

\item{layer.name}{the name of the layer to be shown on the map}

\item{...}{additional arguments passed on to repective functions.
See \code{\link{addRasterImage}}, \code{\link{addCircles}},
\code{\link{addPolygons}}, \code{\link{addPolylines}} for details}

\item{zcol}{attribute name(s) or column number(s) in attribute table
of the column(s) to be rendered}

\item{burst}{whether to show all (TRUE) or only one (FALSE) layers}

\item{color}{color (palette) for points/polygons/lines}

\item{cex}{attribute name(s) or column number(s) in attribute table
of the column(s) to be used for defining the size of circles}

\item{lwd}{line width}

\item{alpha}{opacity of the lines or points}

\item{popup}{a character vector of the HTML content for the popups. See
\code{\link{addControl}} for details.}

\item{easter.egg}{well, you might find out if you set this to TRUE}
}
\description{
this function produces an interactive view of the specified
spatial object(s) on top of the specified base maps.
}
\section{Methods (by class)}{
\itemize{
\item \code{RasterStackBrick}: \code{\link{stack}} / \code{\link{brick}}

\item \code{Satellite}: \code{\link{satellite}}

\item \code{SpatialPixelsDataFrame}: \code{\link{SpatialPixelsDataFrame}}

\item \code{SpatialPointsDataFrame}: \code{\link{SpatialPointsDataFrame}}

\item \code{SpatialPoints}: \code{\link{SpatialPoints}}

\item \code{SpatialPolygonsDataFrame}: \code{\link{SpatialPolygonsDataFrame}}

\item \code{SpatialPolygons}: \code{\link{SpatialPolygons}}

\item \code{SpatialLinesDataFrame}: \code{\link{SpatialLinesDataFrame}}

\item \code{SpatialLines}: \code{\link{SpatialLines}}

\item \code{missing}: initiate a map without an object

\item \code{ANY}: alias for ease of typing
}}
\examples{
\dontrun{
mapview()

### raster data ###
library(sp)
library(raster)

# SpatialPixelsDataFrame
data(meuse.grid)
coordinates(meuse.grid) <- ~x+y
proj4string(meuse.grid) <- CRS("+init=epsg:28992")
gridded(meuse.grid) <- TRUE

mapView(meuse.grid, zcol = "soil")

# raster stack
m1 <- mapview(poppendorf[[10]])
m1

### point vector data ###
## SpatialPointsDataFrame ##
data(meuse)
coordinates(meuse) <- ~x+y
proj4string(meuse) <- CRS("+init=epsg:28992")

# all layers of meuse
mapview(meuse, burst = TRUE)

# only one layer, all info in popups
mapview(meuse)

## SpatialPoints ##
meuse_pts <- as(meuse, "SpatialPoints")
mapview(meuse_pts)



### overlay vector on top of raster ###
mapview(meuse.grid, zcol = "ffreq") + meuse

### polygon vector data ###
data("gadmCHE")
m <- mapview(gadmCHE)
m

## points on polygons ##
centres <- data.frame(coordinates(gadmCHE))
names(centres) <- c("x", "y")
coordinates(centres) <- ~ x + y
projection(centres) <- projection(gadmCHE)
m + centres

### lines vector data
data("atlStorms2005")
mapview(atlStorms2005)
mapview(atlStorms2005, burst = TRUE)
}

}
\author{
Tim Appelhans
}

