% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_leg_p.R
\name{mf_legend_p}
\alias{mf_legend_p}
\title{Plot a legend for a proportional symbols map}
\usage{
mf_legend_p(
  pos = "left",
  val,
  col = "tomato4",
  inches,
  symbol = "circle",
  border,
  lwd = 0.7,
  title = "Legend Title",
  title_cex = 0.8,
  val_cex = 0.6,
  val_rnd = 0,
  frame = FALSE,
  bg,
  fg,
  cex = 1,
  self_adjust = FALSE
)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top",
"topright", "right", "bottomright", "bottom", "bottomleft",
"left", "interactive" or a vector of two coordinates in map units
(c(x, y)).}

\item{val}{vector of values (at least min and max).}

\item{col}{color of the symbols}

\item{inches}{size of the biggest symbol (radius for circles, half width
for squares) in inches}

\item{symbol}{type of symbols, 'circle' or 'square'}

\item{border}{color of the symbols borders}

\item{lwd}{width of the symbols borders}

\item{title}{title of the legend}

\item{title_cex}{size of the legend title}

\item{val_cex}{size of the values in the legend}

\item{val_rnd}{number of decimal places of the values in
the legend.}

\item{frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{bg}{background of the legend}

\item{fg}{foreground of the legend}

\item{cex}{size of the legend; 2 means two times bigger}

\item{self_adjust}{if TRUE values are self-adjusted to keep min, max and
intermediate rounded values}
}
\value{
No return value, a legend is displayed.
}
\description{
Deprecated.

This function plots a legend for proportional symbols.
}
\examples{
\dontrun{
plot.new()
plot.window(xlim = c(0, 1), ylim = c(0, 1), asp = 1)
mf_legend_p(val = c(1, 20, 100), col = "red", inches = .3)
}
}
\keyword{internal}
