% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_prop_typo.R
\name{mf_prop_typo}
\alias{mf_prop_typo}
\title{Plot proportional symbols using typology coloration}
\usage{
mf_prop_typo(
  x,
  var,
  inches = 0.3,
  val_max,
  symbol = "circle",
  pal = "Dynamic",
  alpha = 1,
  val_order,
  border,
  lwd = 0.7,
  lwd_max = 15,
  col_na = "white",
  leg_pos = mf_get_leg_pos(x, 2),
  leg_title = var,
  leg_title_cex = c(0.8, 0.8),
  leg_val_cex = c(0.6, 0.6),
  leg_val_rnd = c(0),
  leg_no_data = "No data",
  leg_frame = c(FALSE, FALSE),
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{inches}{size of the biggest symbol (radius for circles, half width for squares) in inches.}

\item{val_max}{maximum value used for proportional symbols}

\item{symbol}{type of symbols, 'circle' or 'square'}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{alpha}{if \code{pal} is a \link{hcl.colors} palette name, the alpha-transparency level in the range [0,1]}

\item{val_order}{values order, a character vector that matches var modalities}

\item{border}{border color}

\item{lwd}{border width}

\item{lwd_max}{line width of the largest line}

\item{col_na}{color for missing values}

\item{leg_pos}{position of the legend, two of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). leg_pos argument can be c('position', 'position'), c('position', x2, y2), c(x1,y1, 'position') or c(x1, y1, x2, y2). Use NA to avoid plotting the legend, use 'interactive' to choose thelegend position interactively.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot proportional symbols with colors based on qualitative data.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_prop_typo(mtq, c("POP", "STATUS"))

mtq[6, "STATUS"] <- NA
mf_map(mtq)
mf_prop_typo(
  x = mtq, var = c("POP", "STATUS"), inches = .35, border = "tomato4",
  val_max = 90000, symbol = "circle", col_na = "grey", pal = "Dynamic",
  lwd = 2,
  leg_pos = c("bottomright", "bottomleft"),
  leg_title = c("Population", "Municipality\nstatus"),
  leg_title_cex = c(0.9, 0.9),
  leg_val_cex = c(.7, .7),
  val_order = c("Prefecture", "Sub-prefecture", "Simple municipality"),
  leg_no_data = "No dada",
  leg_frame = c(TRUE, TRUE),
  add = TRUE
)
}
\keyword{internal}
